/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.automata.deterministic;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.byteseek.automata.State;
import net.byteseek.automata.Transition;
import net.byteseek.automata.factory.MutableStateFactory;
import net.byteseek.automata.factory.StateFactory;
import net.byteseek.automata.factory.TransitionFactory;
import net.byteseek.automata.walker.Action;
import net.byteseek.automata.walker.StateChildWalker;
import net.byteseek.automata.walker.Step;
import net.byteseek.matcher.automata.ByteMatcherTransitionFactory;
import net.byteseek.utils.collections.IdentityHashSet;

public final class DfaBuilder<T> {
    private final StateFactory<T> stateFactory;
    private final TransitionFactory<T, Collection<Byte>> transitionFactory;

    public DfaBuilder() {
        this(null, null);
    }

    public DfaBuilder(StateFactory<T> stateFactory) {
        this(stateFactory, null);
    }

    public DfaBuilder(TransitionFactory<T, Collection<Byte>> transitionFactory) {
        this(null, transitionFactory);
    }

    public DfaBuilder(StateFactory<T> stateFactory, TransitionFactory<T, Collection<Byte>> transitionFactory) {
        this.stateFactory = stateFactory == null ? new MutableStateFactory() : stateFactory;
        this.transitionFactory = transitionFactory == null ? new ByteMatcherTransitionFactory() : transitionFactory;
    }

    public State<T> build(State<T> initialState) {
        IdentityHashSet<State<T>> stateSet = new IdentityHashSet<State<T>>();
        stateSet.add(initialState);
        IdentityHashMap<Set<State<T>>, State<T>> nfaToDfa = new IdentityHashMap<Set<State<T>>, State<T>>();
        return this.getState(stateSet, nfaToDfa);
    }

    public State<T> build(Collection<State<T>> initialStates) {
        return this.build(this.join(initialStates));
    }

    private State<T> getState(Set<State<T>> stateSet, Map<Set<State<T>>, State<T>> stateSetsSeenSoFar) {
        if (stateSetsSeenSoFar.containsKey(stateSet)) {
            return stateSetsSeenSoFar.get(stateSet);
        }
        return this.createState(stateSet, stateSetsSeenSoFar);
    }

    private State<T> createState(Set<State<T>> sourceStates, Map<Set<State<T>>, State<T>> stateSetsSeenSoFar) {
        boolean isFinal = this.anyStatesAreFinal(sourceStates);
        State<T> newState = this.stateFactory.create(isFinal);
        stateSetsSeenSoFar.put(sourceStates, newState);
        for (State<T> state : sourceStates) {
            newState.addAllAssociations(state.associationIterator());
        }
        this.createDfaTransitions(sourceStates, newState, stateSetsSeenSoFar);
        return newState;
    }

    private void createDfaTransitions(Set<State<T>> stateSet, State<T> newState, Map<Set<State<T>>, State<T>> stateSetsSeenSoFar) {
        Map<Set<State<T>>, Set<Byte>> targetStatesToBytes = this.getDfaTransitionInfo(stateSet);
        for (Map.Entry<Set<State<T>>, Set<Byte>> targetEntry : targetStatesToBytes.entrySet()) {
            Set<Byte> transitionBytes = targetEntry.getValue();
            State<T> targetDFAState = this.getState(targetEntry.getKey(), stateSetsSeenSoFar);
            Transition<T> transition = this.transitionFactory.create(transitionBytes, false, targetDFAState);
            newState.addTransition(transition);
        }
    }

    private Map<Set<State<T>>, Set<Byte>> getDfaTransitionInfo(Set<State<T>> sourceStates) {
        Map<Byte, Set<State<T>>> byteToStates = this.buildByteToStates(sourceStates);
        return this.getStatesToBytes(byteToStates);
    }

    private Map<Byte, Set<State<T>>> buildByteToStates(Set<State<T>> states) {
        LinkedHashMap<Byte, Set<State<T>>> byteToTargetStates = new LinkedHashMap<Byte, Set<State<T>>>();
        for (State<T> state : states) {
            this.buildByteToStates(state, byteToTargetStates);
        }
        return byteToTargetStates;
    }

    public State<T> join(Iterable<State<T>> automata) {
        Iterator<State<T>> automataFirstStates = automata.iterator();
        if (automataFirstStates.hasNext()) {
            State<T> root = automataFirstStates.next();
            boolean isFinal = root.isFinal();
            while (automataFirstStates.hasNext()) {
                State<T> automataFirstState = automataFirstStates.next();
                isFinal |= automataFirstState.isFinal();
                this.replaceReachableReferences(automataFirstState, root);
                root.addAllTransitions(automataFirstState.iterator());
                root.addAllAssociations(automataFirstState.associationIterator());
            }
            root.setIsFinal(isFinal);
            return root;
        }
        return null;
    }

    private void replaceReachableReferences(final State<T> oldState, final State<T> newState) {
        Action replaceWithNewState = new Action<T>(){

            @Override
            public boolean process(Step<T> step) {
                State stateToUpdate = step.currentState;
                List existingTransitions = stateToUpdate.getTransitions();
                for (Transition transition : existingTransitions) {
                    if (transition.getToState() != oldState) continue;
                    Transition newTransition = transition.newTransition(newState);
                    stateToUpdate.replaceTransition(transition, newTransition);
                }
                return true;
            }
        };
        StateChildWalker.walkAutomata(oldState, replaceWithNewState);
    }

    private void buildByteToStates(State<T> state, Map<Byte, Set<State<T>>> byteToTargetStates) {
        for (Transition<T> transition : state) {
            State<T> transitionToState = transition.getToState();
            byte[] transitionBytes = transition.getBytes();
            int stop = transitionBytes.length;
            for (int index = 0; index < stop; ++index) {
                Byte transitionByte = transitionBytes[index];
                Set<State<T>> states = byteToTargetStates.get(transitionByte);
                if (states == null) {
                    states = new IdentityHashSet<State<T>>();
                    byteToTargetStates.put(transitionByte, states);
                }
                states.add(transitionToState);
            }
        }
    }

    public Map<Set<State<T>>, Set<Byte>> getStatesToBytes(Map<Byte, Set<State<T>>> bytesToTargetStates) {
        IdentityHashMap<Set<State<T>>, Set<Byte>> statesToBytes = new IdentityHashMap<Set<State<T>>, Set<Byte>>();
        for (Map.Entry<Byte, Set<State<T>>> transitionByte : bytesToTargetStates.entrySet()) {
            Set<State<T>> targetStates = transitionByte.getValue();
            TreeSet<Byte> targetStateBytes = (TreeSet<Byte>)statesToBytes.get(targetStates);
            if (targetStateBytes == null) {
                targetStateBytes = new TreeSet<Byte>();
                statesToBytes.put(targetStates, targetStateBytes);
            }
            targetStateBytes.add(transitionByte.getKey());
        }
        return statesToBytes;
    }

    private boolean anyStatesAreFinal(Set<State<T>> sourceStates) {
        for (State<T> state : sourceStates) {
            if (!state.isFinal()) continue;
            return true;
        }
        return false;
    }
}

