/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.EnumerationType;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import edu.harvard.hul.ois.jhove.module.Utf8BlockMarker;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class HtmlMetadata {
    private String _title = null;
    private String _lang = null;
    private List _meta = null;
    private String _charset = null;
    private TreeSet _languages = null;
    private List _links = null;
    private List _images = null;
    private List _citations = null;
    private List _defs = null;
    private List _frames = null;
    private List _scripts = null;
    private List _abbrs;
    private TreeSet _entities = null;
    private Property _propUnderConstruction = null;
    private Utf8BlockMarker utf8BM = new Utf8BlockMarker();

    public void setTitle(String title) {
        this._title = title;
    }

    public void setLanguage(String lang) {
        this._lang = lang;
    }

    public void addLanguage(String lang) {
        if (!lang.equals(this._lang)) {
            if (this._languages == null) {
                this._languages = new TreeSet();
            }
            this._languages.add(lang);
        }
    }

    public void addCitation(String text) {
        if (this._citations == null) {
            this._citations = new LinkedList();
        }
        this._citations.add(text);
    }

    public void addMeta(Property prop) {
        String valContentLanguage;
        if (this._meta == null) {
            this._meta = new LinkedList();
        }
        this._meta.add(prop);
        String valContentType = this.extractHttpEquivValue(prop, "Content-Type");
        if (valContentType != null) {
            String toSearch = "charset=";
            int indexOfCharset = valContentType.indexOf("charset=");
            if (indexOfCharset != -1) {
                this.setCharset(valContentType.substring(indexOfCharset + "charset=".length()));
            }
        }
        if ((valContentLanguage = this.extractHttpEquivValue(prop, "Content-Language")) != null) {
            this.setLanguage(valContentLanguage);
        }
    }

    public String extractHttpEquivValue(Property prop, String httpEquivValue) {
        Property content;
        String val;
        if (httpEquivValue == null) {
            return null;
        }
        String value = null;
        Property httpEquiv = prop.getByName("Httpequiv");
        if (httpEquiv != null && PropertyArity.SCALAR.equals((EnumerationType)httpEquiv.getArity()) && PropertyType.STRING.equals((EnumerationType)httpEquiv.getType()) && httpEquivValue.equalsIgnoreCase(val = (String)httpEquiv.getValue()) && (content = prop.getByName("Content")) != null && PropertyArity.SCALAR.equals((EnumerationType)content.getArity()) && PropertyType.STRING.equals((EnumerationType)content.getType())) {
            value = (String)content.getValue();
        }
        return value;
    }

    public void setCharset(String charset) {
        this._charset = charset;
    }

    public void addFrame(Property prop) {
        if (this._frames == null) {
            this._frames = new LinkedList();
        }
        this._frames.add(prop);
    }

    public void addAbbr(Property prop) {
        if (this._abbrs == null) {
            this._abbrs = new LinkedList();
        }
        this._abbrs.add(prop);
    }

    public void addLink(String link) {
        if (this._links == null) {
            this._links = new LinkedList();
        }
        this._links.add(link);
    }

    public void addImage(Property prop) {
        if (this._images == null) {
            this._images = new LinkedList();
        }
        this._images.add(prop);
    }

    public void addDef(String text) {
        if (this._defs == null) {
            this._defs = new LinkedList();
        }
        this._defs.add(text);
    }

    public void addScript(String stype) {
        if (this._scripts == null) {
            this._scripts = new LinkedList();
        }
        this._scripts.add(stype);
    }

    public void addEntity(String entity) {
        if (this._entities == null) {
            this._entities = new TreeSet();
        }
        this._entities.add(entity);
    }

    public Utf8BlockMarker getUtf8BlockMarker() {
        return this.utf8BM;
    }

    public String getTitle() {
        return this._title;
    }

    public String getCharset() {
        return this._charset;
    }

    public Property toProperty(TextMDMetadata _textMD) {
        Property p;
        LinkedList<Property> propList = new LinkedList<Property>();
        Property val = new Property("HTMLMetadata", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        if (this._lang != null) {
            propList.add(new Property("PrimaryLanguage", PropertyType.STRING, (Object)this._lang));
            if (_textMD != null) {
                _textMD.setLanguage(this._lang);
            }
        }
        if (this._languages != null) {
            propList.add(new Property("OtherLanguages", PropertyType.STRING, PropertyArity.SET, (Object)this._languages));
        }
        if (this._title != null) {
            propList.add(new Property("Title", PropertyType.STRING, (Object)this._title));
        }
        if (this._meta != null) {
            propList.add(new Property("MetaTags", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._meta));
        }
        if (this._frames != null) {
            propList.add(new Property("Frames", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._frames));
        }
        if (this._links != null) {
            propList.add(new Property("Links", PropertyType.STRING, PropertyArity.LIST, (Object)this._links));
        }
        if (this._scripts != null) {
            propList.add(new Property("Scripts", PropertyType.STRING, PropertyArity.LIST, (Object)this._scripts));
        }
        if (this._images != null) {
            propList.add(new Property("Images", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._images));
        }
        if (this._citations != null) {
            propList.add(new Property("Citations", PropertyType.STRING, PropertyArity.LIST, (Object)this._citations));
        }
        if (this._defs != null) {
            propList.add(new Property("DefinedTerms", PropertyType.STRING, PropertyArity.LIST, (Object)this._defs));
        }
        if (this._abbrs != null) {
            propList.add(new Property("Abbreviations", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._abbrs));
        }
        if (this._entities != null) {
            propList.add(new Property("Entities", PropertyType.STRING, PropertyArity.SET, (Object)this._entities));
        }
        if (this.utf8BM != null && (p = this.utf8BM.getBlocksUsedProperty("UnicodeEntityBlocks")) != null) {
            propList.add(p);
        }
        if (_textMD != null) {
            propList.add(new Property("TextMDMetadata", PropertyType.TEXTMDMETADATA, PropertyArity.SCALAR, (Object)_textMD));
        }
        if (propList.isEmpty()) {
            return null;
        }
        return val;
    }

    public void setPropUnderConstruction(Property p) {
        this._propUnderConstruction = p;
    }

    public Property getPropUnderConstruction() {
        return this._propUnderConstruction;
    }

    public void addToPropUnderConstruction(char[] ch, int start, int length) {
        if (this._propUnderConstruction != null) {
            String argStr = new String(ch, start, length);
            String name = this._propUnderConstruction.getName();
            Object val = this._propUnderConstruction.getValue();
            if ("abbr".equals(name)) {
                List propList = (List)this._propUnderConstruction.getValue();
                Property abProp = new Property("abbr", PropertyType.STRING, (Object)argStr);
                propList.add(0, abProp);
            } else if ("title".equals(name) || "dfn".equals(name)) {
                this._propUnderConstruction = new Property(name, PropertyType.STRING, (Object)((String)val + argStr));
            }
        }
    }

    public void finishPropUnderConstruction() {
        if (this._propUnderConstruction != null) {
            String name = this._propUnderConstruction.getName();
            if ("abbr".equals(name)) {
                this.addAbbr(this._propUnderConstruction);
            } else if ("title".equals(name)) {
                this._title = (String)this._propUnderConstruction.getValue();
            }
            this._propUnderConstruction = null;
        }
    }
}

