/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITMP
extends TiffProfileClassIT {
    public TiffProfileClassITMP() {
        this._profileText = "TIFF/IT-MP (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        int pad;
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getBitsPerSample() == null) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{1, 32895})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1})) {
            return false;
        }
        if (niso.getCompressionScheme() == 32895 && (pad = tifd.getRasterPadding()) != 0 && pad != 1 && pad != 2 && pad != 9 && pad != 10) {
            return false;
        }
        if (!this.satisfiesImageColorIndicator(tifd, new int[]{0, 1})) {
            return false;
        }
        int ind = tifd.getImageColorIndicator();
        return ind != 1 || tifd.getImageColorValue() != -1;
    }
}

