/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.matchUtils;

public class DigitsMatcher {
    public int match(String digitStr1, String digitStr2) {
        if (digitStr1.equals(digitStr2)) {
            return 100;
        }
        if (this.isInverseMatch(digitStr1, digitStr2)) {
            return 100;
        }
        if (this.is2AdjacentMatch(digitStr1, digitStr2)) {
            return 100;
        }
        if (this.is2AttachedAdjacentMatch(digitStr1, digitStr2)) {
            return 100;
        }
        if (this.isLeadingZeroMatch(digitStr1, digitStr2)) {
            return 100;
        }
        if (this.idReapetedDigitMatch(digitStr1, digitStr2)) {
            return 100;
        }
        if (this.isMissingFirstOrLastMatch(digitStr1, digitStr2)) {
            return 100;
        }
        if (this.isDistinguishedInOneDigitMatch(digitStr1, digitStr2)) {
            return 100;
        }
        if (this.is3DigitsPermutation(digitStr1, digitStr2)) {
            return 100;
        }
        return 0;
    }

    private boolean isInverseMatch(String digitStr1, String digitStr2) {
        if (digitStr1.length() != digitStr2.length() || digitStr2.length() < 3) {
            return false;
        }
        return digitStr1.equals(new StringBuilder(digitStr2).reverse().toString());
    }

    private boolean is2AttachedAdjacentMatch(String digitStr1, String digitStr2) {
        if (digitStr1.length() != digitStr2.length() || digitStr2.length() < 3) {
            return false;
        }
        int i = 0;
        int j = digitStr1.length() - 1;
        while (digitStr1.charAt(i) == digitStr2.charAt(i)) {
            ++i;
        }
        while (digitStr1.charAt(j) == digitStr2.charAt(j)) {
            --j;
        }
        return !(j != i || i <= 0 || j >= digitStr1.length() - 1 || digitStr1.charAt(i + 1) != digitStr1.charAt(i) && digitStr1.charAt(i - 1) != digitStr1.charAt(i) || digitStr2.charAt(j + 1) != digitStr2.charAt(j) && digitStr2.charAt(j - 1) != digitStr1.charAt(j));
    }

    private boolean is2AdjacentMatch(String digitStr1, String digitStr2) {
        boolean foundAdjacent = false;
        if (digitStr1.length() != digitStr2.length() || digitStr2.length() < 3) {
            return false;
        }
        for (int i = 0; i < digitStr1.length(); ++i) {
            if (digitStr1.charAt(i) == digitStr2.charAt(i) || digitStr1.charAt(i) == digitStr2.charAt(i)) continue;
            if (!foundAdjacent && i < digitStr1.length() - 1 && digitStr1.charAt(i + 1) == digitStr2.charAt(i) && digitStr1.charAt(i) == digitStr2.charAt(i + 1)) {
                foundAdjacent = true;
                ++i;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean isLeadingZeroMatch(String digitStr1, String digitStr2) {
        return digitStr1.equals(digitStr2);
    }

    private boolean idReapetedDigitMatch(String digitStr1, String digitStr2) {
        char c;
        int j;
        boolean foundReapeted = false;
        if (digitStr1.length() == digitStr2.length()) {
            return false;
        }
        if (Math.min(digitStr1.length(), digitStr2.length()) < 2) {
            return false;
        }
        if (digitStr1.length() > digitStr2.length()) {
            String tmp = digitStr1;
            digitStr1 = digitStr2;
            digitStr2 = tmp;
        }
        int len1 = digitStr1.length();
        int len2 = digitStr2.length();
        int i = 0;
        for (j = 0; i < len1 && j < len2; ++i, ++j) {
            if (digitStr1.charAt(i) == digitStr2.charAt(j)) continue;
            if (digitStr1.charAt(i) != digitStr2.charAt(j) && !foundReapeted) {
                foundReapeted = true;
                c = digitStr2.charAt(j);
                while (j < len2 && c == digitStr2.charAt(j)) {
                    ++j;
                }
                if (j < len2 && digitStr1.charAt(i) == digitStr2.charAt(j)) continue;
                return false;
            }
            return false;
        }
        if (j < len2 && !foundReapeted) {
            c = digitStr2.charAt(j);
            while (j < len2 && c == digitStr2.charAt(j)) {
                ++j;
            }
        }
        return j == len2 && i == len1 && digitStr2.charAt(j - 1) == digitStr1.charAt(i - 1);
    }

    private boolean isMissingFirstOrLastMatch(String digitStr1, String digitStr2) {
        if (Math.max(digitStr1.length(), digitStr2.length()) < 3) {
            return false;
        }
        if (Math.abs(digitStr1.length() - digitStr2.length()) != 1) {
            return false;
        }
        return digitStr1.startsWith(digitStr2) || digitStr1.endsWith(digitStr2) || digitStr2.startsWith(digitStr1) || digitStr2.endsWith(digitStr1);
    }

    private boolean isDistinguishedInOneDigitMatch(String digitStr1, String digitStr2) {
        boolean foundOneUnmatchedChar = false;
        if (Math.min(digitStr1.length(), digitStr2.length()) < 4) {
            return false;
        }
        if (digitStr1.length() != digitStr2.length()) {
            return false;
        }
        for (int i = 0; i < digitStr1.length(); ++i) {
            if (digitStr1.charAt(i) == digitStr2.charAt(i)) continue;
            if (!foundOneUnmatchedChar && digitStr1.charAt(i) != digitStr2.charAt(i)) {
                foundOneUnmatchedChar = true;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean is3DigitsPermutation(String digitStr1, String digitStr2) {
        int i = 0;
        int j = 0;
        if (digitStr1.length() != digitStr2.length() || digitStr1.length() < 3) {
            return false;
        }
        for (i = 0; i < digitStr1.length() && digitStr1.charAt(i) == digitStr2.charAt(i); ++i) {
        }
        for (j = digitStr1.length() - 1; j > 0 && digitStr1.charAt(j) == digitStr2.charAt(j); --j) {
        }
        if (j - i + 1 != 3) {
            return false;
        }
        String perCandidate1 = digitStr1.substring(i, j + 1);
        String perCandidate2 = digitStr2.substring(i, j + 1);
        return perCandidate1.charAt(0) == perCandidate1.charAt(2) && perCandidate2.charAt(0) == perCandidate2.charAt(2) && perCandidate1.charAt(0) == perCandidate2.charAt(1) && perCandidate2.charAt(0) == perCandidate1.charAt(1);
    }
}

