/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.HPersistent;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.model.annotation.emailData;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@MappedSuperclass
public class HStandardEntity
extends HPersistent {
    private static final long serialVersionUID = 1L;
    private String application;
    private String creator;
    private String modifiedBy;
    private Calendar createDate = Calendar.getInstance();
    private DividedDate createDateDummy;
    private Calendar modificationDate;
    private DividedDate modificationDateDummy;

    public HStandardEntity() {
        this.setCreateDate(this.createDate);
        this.modificationDate = Calendar.getInstance();
        this.setModificationDate(this.modificationDate);
        this.creator = "Ex Libris";
        this.modifiedBy = "Ex Libris";
    }

    @emailData
    @Column
    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    @Column
    @Searchable
    @emailData
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @emailData
    @Column(name="modified_by")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @emailData
    @Column(name="create_date")
    public Calendar getCreateDate() {
        if (this.createDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.createDate;
    }

    public void setCreateDate(Calendar createDate) {
        this.createDate = createDate;
        this.createDateDummy = new DividedDate(this.createDate);
        this.createDate = this.createDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getCreateDateDummy() {
        return this.createDateDummy;
    }

    public void setCreateDateDummy(DividedDate createDateDummy) {
        this.createDateDummy = createDateDummy;
    }

    @emailData
    @Column(name="modification_date")
    public Calendar getModificationDate() {
        if (this.modificationDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.modificationDate;
    }

    public void setModificationDate(Calendar modificationDate) {
        this.modificationDate = modificationDate;
        this.modificationDateDummy = new DividedDate(this.modificationDate);
        this.modificationDate = this.modificationDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getModificationDateDummy() {
        return this.modificationDateDummy;
    }

    public void setModificationDateDummy(DividedDate modificationDateDummy) {
        this.modificationDateDummy = modificationDateDummy;
    }

    public Enum getEnumByOrdinal(Enum[] enums, String ordinalStr) {
        Enum enumEl = null;
        int ordinal = -1;
        try {
            ordinal = Integer.parseInt(ordinalStr);
        }
        catch (NumberFormatException e) {
            return enumEl;
        }
        if (ordinal < 0 || ordinal >= enums.length) {
            return enumEl;
        }
        for (Enum currEnumEl : enums) {
            if (currEnumEl.ordinal() != ordinal) continue;
            enumEl = currEnumEl;
            break;
        }
        return enumEl;
    }
}

