/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.svc.api.utils.TreeNode;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSTreeUtil {
    public static final String NODE_PREFIX = "node_";

    public static String getXMLFromTreeNodeList(Collection<? extends TreeNode> tree, List<String> selectedIDs) {
        StringBuilder sb = new StringBuilder("<root>");
        if (tree != null) {
            for (TreeNode treeNode : tree) {
                sb.append(String.format("<item id='node_%s'", treeNode.getId()));
                if (selectedIDs != null && selectedIDs.contains(String.valueOf(treeNode.getId()))) {
                    sb.append(" selected='true'");
                }
                if (treeNode.getParentId() != null) {
                    sb.append(String.format(" parent_id='node_%s'", treeNode.getParentId()));
                }
                sb.append(String.format("><content><name>%s</name></content></item>", StringEscapeUtils.escapeXml((String)treeNode.getName())));
            }
        }
        return sb.append("</root>").toString().replace("\n", "");
    }

    public static String getTreeJson(Collection<? extends TreeNode> tree, boolean showCollId) {
        JSONArray collections = new JSONArray();
        try {
            if (tree != null) {
                for (TreeNode treeNode : tree) {
                    JSONObject collectionData = new JSONObject();
                    collectionData.put("id", (Object)treeNode.getId().toString());
                    collectionData.put("parent", treeNode.getParentId() != null ? treeNode.getParentId() : "#");
                    collectionData.put("text", (Object)(!showCollId ? treeNode.getName() : treeNode.getName() + " (" + treeNode.getId().toString() + ")"));
                    collectionData.put("children", treeNode.isHasChildren());
                    collections.put((Object)collectionData);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return collections.toString();
    }

    public static Long getNodeId(String treeNodeId) {
        return StringUtils.isNotBlank((String)treeNodeId) ? Long.valueOf(Long.parseLong(treeNodeId)) : null;
    }

    public static String getTreeNodeId(Long nodeId) {
        if (nodeId == null) {
            return null;
        }
        return NODE_PREFIX + nodeId;
    }
}

