/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.sds;

import com.exlibris.digitool.sds.xmlbeans.DigitalBinDocument;
import com.exlibris.digitool.sds.xmlbeans.LibListDocument;
import com.exlibris.digitool.sds.xmlbeans.LibRecord;
import com.exlibris.digitool.sds.xmlbeans.StaffInfoDocument;
import com.exlibris.digitool.sds.xmlbeans.StaffListDocument;
import com.exlibris.digitool.sds.xmlbeans.StaffRecord;
import com.exlibris.digitool.sds.xmlbeans.Z66;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xmlbeans.XmlException;

public class LegacyResult
implements Serializable {
    private String m_result = null;

    public LegacyResult(String xml) {
        this.m_result = xml;
    }

    public String getEntireMessage() {
        return this.m_result;
    }

    public String getError() {
        StringBuffer str = new StringBuffer(this.m_result);
        int sessIdnex = str.indexOf("<error>");
        int sessEndIdnex = str.indexOf("</error>");
        if (sessIdnex != -1) {
            String ret = str.substring(sessIdnex += 7, sessEndIdnex);
            return ret;
        }
        return "";
    }

    public String getSessionId() {
        StringBuffer str = new StringBuffer(this.m_result);
        int sessIdnex = str.indexOf("<session-id>");
        int sessEndIdnex = str.indexOf("</session-id>");
        if (sessIdnex != -1) {
            String ret = str.substring(sessIdnex += 12, sessEndIdnex);
            return ret;
        }
        return "";
    }

    public boolean getIsStaffAuthenticated() {
        String ret;
        StringBuffer str = new StringBuffer(this.m_result);
        int sessIdnex = str.indexOf("<authenticated>");
        int sessEndIdnex = str.indexOf("</authenticated>");
        return sessIdnex != -1 && (ret = str.substring(sessIdnex += 15, sessEndIdnex)) != null && ret.equalsIgnoreCase("Y");
    }

    public boolean getIsStaffAutherized() {
        String ret;
        StringBuffer str = new StringBuffer(this.m_result);
        int sessIdnex = str.indexOf("<allowed>");
        int sessEndIdnex = str.indexOf("</allowed>");
        if (sessIdnex != -1 && (ret = str.substring(sessIdnex += 9, sessEndIdnex)) != null && ret.equalsIgnoreCase("Y")) {
            return true;
        }
        return true;
    }

    public String getAdminUnit() {
        StringBuffer str = new StringBuffer(this.m_result);
        int sessIdnex = str.indexOf("<sds:z66-user-library>");
        int sessEndIdnex = str.indexOf("</sds:z66-user-library>");
        if (sessIdnex != -1) {
            String ret = str.substring(sessIdnex += "<sds:z66-user-library>".length(), sessEndIdnex);
            return ret;
        }
        return "";
    }

    public String getCollMngGroup() {
        StringBuffer str = new StringBuffer(this.m_result);
        int sessIdnex = str.indexOf("<sds:z66-coll-mng-group>");
        int sessEndIdnex = str.indexOf("</sds:z66-coll-mng-group>");
        if (sessIdnex != -1) {
            String ret = str.substring(sessIdnex += "<sds:z66-coll-mng-group>".length(), sessEndIdnex);
            return ret;
        }
        return "";
    }

    public ArrayList getLibraryList() {
        ArrayList<LibraryObj> aList = new ArrayList<LibraryObj>();
        LibListDocument libListDoc = null;
        try {
            libListDoc = LibListDocument.Factory.parse(this.m_result);
        }
        catch (XmlException e) {
            return null;
        }
        LibListDocument.LibList libList = libListDoc.getLibList();
        String numLines = libList.getNoLines();
        LibRecord[] records = libList.getLibRecordArray();
        for (int i = 0; i < records.length; ++i) {
            LibraryObj lo = new LibraryObj();
            lo.setCode(records[i].getCode());
            lo.setName(records[i].getName());
            lo.setType(records[i].getType());
            lo.setNumLines(numLines);
            aList.add(lo);
        }
        return aList;
    }

    public ArrayList getStaffList() {
        ArrayList<StaffObj> aList = new ArrayList<StaffObj>();
        StaffListDocument staffListDoc = null;
        try {
            staffListDoc = StaffListDocument.Factory.parse(this.m_result);
        }
        catch (XmlException e) {
            return null;
        }
        StaffListDocument.StaffList staffList = staffListDoc.getStaffList();
        byte num = staffList.getNoLines();
        StaffRecord[] sRecord = staffList.getStaffRecordArray();
        for (int i = 0; i < sRecord.length; ++i) {
            StaffObj so = new StaffObj();
            String libName = sRecord[i].getLibrary();
            so.setName(sRecord[i].getName());
            so.setLibrary(libName);
            if (libName != null && libName.equalsIgnoreCase("ADMIN")) {
                StringTokenizer tok = new StringTokenizer(sRecord[i].getUnits());
                String[] adminUnits = new String[tok.countTokens()];
                int cnt = 0;
                while (tok.hasMoreTokens()) {
                    adminUnits[cnt++] = tok.nextToken();
                }
                so.setAdminLibs(adminUnits);
            }
            aList.add(so);
        }
        return aList;
    }

    public DigitalBinDocument.DigitalBin getDigitalBin() {
        DigitalBinDocument digBin;
        try {
            digBin = DigitalBinDocument.Factory.parse(this.m_result);
        }
        catch (XmlException e) {
            return null;
        }
        return digBin.getDigitalBin();
    }

    public Hashtable getZ66Values() {
        Hashtable<String, String> aList = new Hashtable<String, String>();
        StaffInfoDocument sid = null;
        try {
            sid = StaffInfoDocument.Factory.parse(this.m_result);
        }
        catch (XmlException x) {
            return null;
        }
        StaffInfoDocument.StaffInfo sInfo = sid.getStaffInfo();
        Z66 z66 = sInfo.getZ66();
        String str = z66.getZ66BudgetProxy();
        if (str != null) {
            aList.put("BudgetProxy", str);
        }
        if ((str = z66.getZ66CatalogProxy()) != null) {
            aList.put("CatalogProxy", str);
        }
        if ((str = z66.getZ66FunctionProxy()) != null) {
            aList.put("FunctionProxy", str);
        }
        if ((str = z66.getZ66OrderUnitProxy()) != null) {
            aList.put("OrderUnitProxy", str);
        }
        if ((str = z66.getZ66UserCatLevel()) != null) {
            aList.put("UserCatLevel", str);
        }
        if ((str = z66.getZ66UserCircLevel()) != null) {
            aList.put("UserCircLevel", str);
        }
        if ((str = z66.getZ66UserLibrary()) != null) {
            aList.put("UserLibrary", str);
        }
        if ((str = z66.getZ66UserName()) != null) {
            aList.put("UserName", str);
        }
        if ((str = z66.getZ66UserOwnCheck()) != null) {
            aList.put("UserOwnCheck", str);
        }
        if ((str = z66.getZ66UserOwnCreate()) != null) {
            aList.put("UserOwnCreate", str);
        }
        if ((str = z66.getZ66UserPassword()) != null) {
            aList.put("UserPassword", str);
        }
        if ((str = z66.getZ66UserPasswordEnc()) != null) {
            aList.put("UserPasswordEnc", str);
        }
        return aList;
    }

    public class LibraryObj
    implements Serializable {
        private String m_code = null;
        private String m_name = null;
        private String m_type = null;
        private String m_numLines = null;

        public String getCode() {
            return this.m_code;
        }

        public void setCode(String code) {
            this.m_code = code;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public String getType() {
            return this.m_type;
        }

        public void setType(String type) {
            this.m_type = type;
        }

        public void setNumLines(String lines) {
            this.m_numLines = lines;
        }

        public String getNumLines() {
            return this.m_numLines;
        }
    }

    public class StaffObj
    implements Serializable {
        private String m_name = null;
        private String m_library = null;
        private String[] m_adminLibs = null;

        public StaffObj() {
        }

        public StaffObj(String library) {
            this.m_library = library;
        }

        public String[] getAdminLibs() {
            return this.m_adminLibs;
        }

        public void setAdminLibs(String[] libs) {
            this.m_adminLibs = libs;
        }

        public String getLibrary() {
            return this.m_library;
        }

        public void setLibrary(String library) {
            this.m_library = library;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StaffObj) {
                return ((StaffObj)obj).getLibrary().equals(this.m_library);
            }
            if (obj instanceof String) {
                return ((StaffObj)obj).getLibrary().equals(obj);
            }
            return false;
        }
    }
}

