/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.NameTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.XProfileBase;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public final class X1Profile
extends XProfileBase {
    private boolean _x1aCompliant;

    public X1Profile(PdfModule module) {
        super(module, XProfileBase.PDFX1);
        this._profileText = "ISO PDF/X-1";
    }

    @Override
    public boolean satisfiesThisProfile() {
        this._x1aCompliant = false;
        try {
            PdfDictionary catDict = this._module.getCatalogDict();
            PdfArray intentsArray = (PdfArray)this._module.resolveIndirectObject(catDict.get("OutputIntents"));
            if (intentsArray == null) {
                return false;
            }
            PdfDictionary docInfo = this._module.getDocInfo();
            try {
                PdfSimpleObject conf = (PdfSimpleObject)docInfo.get("GTS_PDFXConformance");
                String cn = conf.getStringValue();
                if (cn.startsWith("PDF/X-1a:")) {
                    this._x1aCompliant = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.outputIntentsOK(intentsArray)) {
                return false;
            }
            if (!this.resourcesOK()) {
                return false;
            }
            if (!this.trailerDictOK()) {
                return false;
            }
            if (!this.infoDictOK("PDF/X-1")) {
                return false;
            }
            if (!this.encryptionOK()) {
                return false;
            }
            if (!this.bboxOK(true)) {
                return false;
            }
            if (this._module.getActionsExist()) {
                return false;
            }
            if (this._module.getEncryptionDict() != null) {
                this._x1aCompliant = false;
            }
            if (!this.checkPrefsAgainstBleedBox()) {
                this._x1aCompliant = false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isX1aCompliant() {
        return this._x1aCompliant;
    }

    private boolean resourcesOK() {
        PageTreeNode docTreeRoot = this._module.getDocumentTree();
        try {
            DocNode docNode;
            docTreeRoot.startWalk();
            while ((docNode = docTreeRoot.nextDocNode()) != null) {
                PdfArray annots;
                PdfDictionary rsrc = docNode.getResources();
                if (rsrc != null) {
                    PdfDictionary cs = (PdfDictionary)this._module.resolveIndirectObject(rsrc.get("ColorSpace"));
                    if (!this.colorSpaceOK(cs)) {
                        return false;
                    }
                    PdfDictionary gs = (PdfDictionary)this._module.resolveIndirectObject(rsrc.get("ExtGState"));
                    if (!this.extGStateOK(gs)) {
                        return false;
                    }
                    PdfDictionary xo = (PdfDictionary)this._module.resolveIndirectObject(rsrc.get("XObject"));
                    if (!this.xObjectsOK(xo)) {
                        return false;
                    }
                }
                if (!(docNode instanceof PageObject)) continue;
                List streams = ((PageObject)docNode).getContentStreams();
                if (streams != null) {
                    ListIterator iter = streams.listIterator();
                    while (iter.hasNext()) {
                        PdfObject filters;
                        PdfStream stream = (PdfStream)iter.next();
                        PdfDictionary dict = stream.getDict();
                        PdfDictionary rs = (PdfDictionary)dict.get("Resources");
                        if (rs != null) {
                            PdfDictionary cs = (PdfDictionary)this._module.resolveIndirectObject(rs.get("ColorSpace"));
                            if (!this.colorSpaceOK(cs)) {
                                return false;
                            }
                            PdfDictionary gs = (PdfDictionary)this._module.resolveIndirectObject(rs.get("ExtGState"));
                            if (!this.extGStateOK(gs)) {
                                return false;
                            }
                            PdfDictionary xo = (PdfDictionary)this._module.resolveIndirectObject(rs.get("XObject"));
                            if (!this.xObjectsOK(xo)) {
                                return false;
                            }
                        }
                        if (this.filter1AOK(filters = dict.get("Filter"))) continue;
                        this._x1aCompliant = false;
                    }
                }
                if ((annots = ((PageObject)docNode).getAnnotations()) == null) continue;
                Vector<PdfObject> annVec = annots.getContent();
                for (int i = 0; i < annVec.size(); ++i) {
                    PdfSimpleObject pcm;
                    PdfDictionary normalDict;
                    Vector<PdfObject> ffVec;
                    PdfDictionary annDict = (PdfDictionary)annVec.elementAt(i);
                    PdfSimpleObject subtypeObj = (PdfSimpleObject)annDict.get("Subtype");
                    if (!"TrapNet".equals(subtypeObj.getStringValue())) continue;
                    PdfArray ff = (PdfArray)annDict.get("FontFauxing");
                    if (ff != null && (ffVec = ff.getContent()).size() > 0) {
                        return false;
                    }
                    PdfDictionary appDict = (PdfDictionary)annDict.get("AP");
                    if (appDict == null || (normalDict = (PdfDictionary)appDict.get("N")) == null || "DeviceCMYK".equals((pcm = (PdfSimpleObject)normalDict.get("PCM")).getStringValue())) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean colorSpaceOK(PdfDictionary cs) {
        if (cs == null) {
            return true;
        }
        Iterator iter = cs.iterator();
        while (iter.hasNext()) {
            PdfSimpleObject baseObj;
            String base;
            PdfSimpleObject altSpaceObj;
            String altSpace;
            PdfObject res = (PdfObject)iter.next();
            if (!(res instanceof PdfArray)) continue;
            Vector<PdfObject> resv = ((PdfArray)res).getContent();
            PdfSimpleObject snameobj = (PdfSimpleObject)resv.elementAt(0);
            String sname = snameobj.getStringValue();
            if (("Separation".equals(sname) || "DeviceN".equals(sname)) && !"DeviceGray".equals(altSpace = (altSpaceObj = (PdfSimpleObject)resv.elementAt(2)).getStringValue()) && !"DeviceCMYK".equals(altSpace)) {
                return false;
            }
            if (!"Indexed".equals(sname) && !"Pattern".equals(sname) || "DeviceCMYK".equals(base = (baseObj = (PdfSimpleObject)resv.elementAt(1)).getStringValue()) || "DeviceGray".equals(base) || "DeviceN".equals(base) || "Separation".equals(base)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean xObjectOK(PdfDictionary xo) {
        if (xo == null) {
            return true;
        }
        if (!super.xObjectOK(xo)) {
            return false;
        }
        try {
            Vector<PdfObject> inkvec;
            PdfSimpleObject inkobj;
            String inkname;
            PdfDictionary opi = (PdfDictionary)xo.get("OPI");
            if (opi == null) {
                return true;
            }
            this._x1aCompliant = false;
            PdfDictionary opi20 = (PdfDictionary)this._module.resolveIndirectObject(opi.get("2.0"));
            if (opi20 == null) {
                return true;
            }
            PdfObject inks = this._module.resolveIndirectObject(opi20.get("Inks"));
            if (inks == null) {
                return true;
            }
            if (inks instanceof PdfSimpleObject ? !"full_color".equals(inkname = ((PdfSimpleObject)inks).getStringValue()) && !"registration".equals(inkname) : inks instanceof PdfArray && !"monochrome".equals((inkobj = (PdfSimpleObject)(inkvec = ((PdfArray)inks).getContent()).elementAt(0)).getStringValue())) {
                return false;
            }
            PdfObject fileObj = this._module.resolveIndirectObject(opi20.get("F"));
            NameTreeNode nameTreeNode = this._module.getEmbeddedFiles();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean encryptionOK() {
        PdfDictionary encryptDict = this._module.getEncryptionDict();
        if (encryptDict == null) {
            return true;
        }
        try {
            PdfSimpleObject filter = (PdfSimpleObject)encryptDict.get("Filter");
            if (!"Standard".equals(filter.getStringValue())) {
                return false;
            }
            PdfSimpleObject perm = (PdfSimpleObject)encryptDict.get("P");
            if (perm == null) {
                return false;
            }
            if ((perm.getIntValue() & 4) == 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean filter1AOK(PdfObject filters) {
        return !this.hasFilters(filters, new String[]{"LZWDecode", "JBIG2Decode"});
    }

    @Override
    protected boolean formObjectOK(PdfDictionary xo) {
        if (xo.get("Ref") != null) {
            this._x1aCompliant = false;
        }
        return true;
    }
}

