/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import net.byteseek.compiler.CompileException;
import net.byteseek.compiler.matcher.SequenceMatcherCompiler;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.ParseTreeUtils;
import net.byteseek.parser.tree.node.BaseNode;
import net.byteseek.parser.tree.node.ChildrenNode;
import net.byteseek.utils.ByteUtils;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceAnchor;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceParser;
import uk.gov.nationalarchives.droid.core.signature.droid6.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid6.SideFragment;
import uk.gov.nationalarchives.droid.core.signature.droid6.SubSequence;

public final class ByteSequenceCompiler {
    public static final ByteSequenceCompiler COMPILER = new ByteSequenceCompiler();
    private static final int MAX_MATCHING_BYTES = 64;
    private static final SequenceMatcherCompiler MATCHER_COMPILER = new SequenceMatcherCompiler();
    private static final ParseTree ZERO_TO_MANY = new ChildrenNode(ParseTreeType.ZERO_TO_MANY, BaseNode.ANY_NODE);
    private static IntPair NO_RESULT = new IntPair(-1, -1);
    private static AnchorStrategy PRONOMStrategy = new PRONOMAnchorStrategy();
    private static AnchorStrategy DROIDStrategy = new DROIDAnchorStrategy();
    private static AnchorStrategy AllowAllStrategy = new AllowAllAnchorStrategy();

    public ByteSequence compile(String droidExpression) throws CompileException {
        return this.compile(droidExpression, ByteSequenceAnchor.BOFOffset, CompileType.DROID);
    }

    public ByteSequence compile(String droidExpression, ByteSequenceAnchor anchor) throws CompileException {
        return this.compile(droidExpression, anchor, CompileType.DROID);
    }

    public ByteSequence compile(String droidExpression, ByteSequenceAnchor anchor, CompileType compileType) throws CompileException {
        ByteSequence newByteSequence = new ByteSequence();
        newByteSequence.setReference(anchor.getAnchorText());
        this.compile(newByteSequence, droidExpression, compileType);
        return newByteSequence;
    }

    public void compile(ByteSequence sequence, String droidExpression) throws CompileException {
        this.compile(sequence, droidExpression, ByteSequenceAnchor.BOFOffset, CompileType.DROID);
    }

    public void compile(ByteSequence sequence, String droidExpression, ByteSequenceAnchor anchor) throws CompileException {
        this.compile(sequence, droidExpression, anchor, CompileType.DROID);
    }

    public void compile(ByteSequence sequence, String droidExpression, ByteSequenceAnchor anchor, CompileType compileType) throws CompileException {
        sequence.setReference(anchor.getAnchorText());
        this.compile(sequence, droidExpression, compileType);
    }

    public void compile(ByteSequence sequence, String droidExpression, CompileType compileType) throws CompileException {
        try {
            ParseTree sequenceNodes = ByteSequenceParser.PARSER.parse(droidExpression);
            this.compile(sequence, sequenceNodes, compileType);
        }
        catch (ParseException ex) {
            throw new CompileException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void compile(ByteSequence sequence, ParseTree sequenceNodes, CompileType compileType) throws CompileException {
        boolean anchoredToEnd = ByteSequenceAnchor.EOFOffset.getAnchorText().equals(sequence.getReference());
        List<ParseTree> sequenceList = this.preprocessSequence(sequenceNodes, anchoredToEnd, compileType);
        int numNodes = sequenceList.size();
        int subSequenceStart = 0;
        for (int nodeIndex = 0; nodeIndex < numNodes; ++nodeIndex) {
            if (sequenceList.get(nodeIndex).getParseTreeType() != ParseTreeType.ZERO_TO_MANY) continue;
            sequence.addSubSequence(this.buildSubSequence(sequenceList, subSequenceStart, nodeIndex, anchoredToEnd, compileType));
            subSequenceStart = nodeIndex + 1;
        }
        if (subSequenceStart < numNodes) {
            sequence.addSubSequence(this.buildSubSequence(sequenceList, subSequenceStart, numNodes, anchoredToEnd, compileType));
        }
    }

    private List<ParseTree> preprocessSequence(ParseTree sequenceNodes, boolean anchoredToEnd, CompileType compileType) throws CompileException {
        int numNodes = sequenceNodes.getNumChildren();
        IntIterator index = anchoredToEnd ? new IntIterator(numNodes - 1, 0) : new IntIterator(0, numNodes - 1);
        ArrayList<ParseTree> sequenceList = new ArrayList<ParseTree>();
        int lastValuePosition = -1;
        while (index.hasNext()) {
            int currentIndex = index.next();
            ParseTree node = sequenceNodes.getChild(currentIndex);
            sequenceList.add(node);
            switch (node.getParseTreeType()) {
                case BYTE: 
                case RANGE: 
                case STRING: 
                case ALL_BITMASK: 
                case SET: 
                case ANY: {
                    lastValuePosition = sequenceList.size() - 1;
                    break;
                }
                case ALTERNATIVES: {
                    lastValuePosition = sequenceList.size() - 1;
                    if (compileType != CompileType.DROID) break;
                    sequenceList.set(sequenceList.size() - 1, this.optimiseSingleByteAlternatives(node));
                    break;
                }
                case ZERO_TO_MANY: {
                    if (lastValuePosition + 1 >= sequenceList.size() - 1) break;
                    sequenceList.add(lastValuePosition + 1, node);
                    sequenceList.remove(sequenceList.size() - 1);
                    break;
                }
                case REPEAT_MIN_TO_MANY: {
                    sequenceList.set(sequenceList.size() - 1, (ParseTree)new ChildrenNode(ParseTreeType.REPEAT, new ParseTree[]{node.getChild(0), BaseNode.ANY_NODE}));
                    sequenceList.add(lastValuePosition + 1, ZERO_TO_MANY);
                    break;
                }
            }
        }
        if (anchoredToEnd) {
            Collections.reverse(sequenceList);
        }
        return sequenceList;
    }

    private ParseTree optimiseSingleByteAlternatives(ParseTree node) throws CompileException {
        if (node.getParseTreeType() == ParseTreeType.ALTERNATIVES) {
            HashSet<Integer> singleByteIndexes = new HashSet<Integer>();
            block6: for (int i = 0; i < node.getNumChildren(); ++i) {
                ParseTree child = node.getChild(i);
                switch (child.getParseTreeType()) {
                    case BYTE: 
                    case RANGE: 
                    case ALL_BITMASK: 
                    case SET: {
                        singleByteIndexes.add(i);
                        continue block6;
                    }
                    case STRING: {
                        String value;
                        try {
                            value = child.getTextValue();
                        }
                        catch (ParseException e) {
                            throw new CompileException(e.getMessage(), (Throwable)e);
                        }
                        if (value.length() != 1 || value.charAt(0) >= '\u0100') continue block6;
                        singleByteIndexes.add(i);
                        continue block6;
                    }
                }
            }
            if (singleByteIndexes.size() > 1) {
                ArrayList<Object> newAlternativeChildren = new ArrayList<Object>();
                ArrayList<ParseTree> setChildren = new ArrayList<ParseTree>();
                for (int i = 0; i < node.getNumChildren(); ++i) {
                    ParseTree child = node.getChild(i);
                    if (singleByteIndexes.contains(i)) {
                        setChildren.add(child);
                        continue;
                    }
                    newAlternativeChildren.add(child);
                }
                ChildrenNode setNode = new ChildrenNode(ParseTreeType.SET, setChildren);
                if (newAlternativeChildren.isEmpty()) {
                    return setNode;
                }
                newAlternativeChildren.add(setNode);
                return new ChildrenNode(ParseTreeType.ALTERNATIVES, newAlternativeChildren);
            }
        }
        return node;
    }

    private SubSequence buildSubSequence(List<ParseTree> sequenceList, int subSequenceStart, int subSequenceEnd, boolean anchoredToEOF, CompileType compileType) throws CompileException {
        IntPair anchorRange = this.locateSearchSequence(sequenceList, subSequenceStart, subSequenceEnd, compileType);
        if (anchorRange == NO_RESULT) {
            throw new CompileException("No anchoring sequence could be found in a subsequence.");
        }
        ParseTree anchorSequence = this.createSubSequenceTree(sequenceList, anchorRange.firstInt, anchorRange.secondInt);
        SequenceMatcher anchorMatcher = (SequenceMatcher)MATCHER_COMPILER.compile((Object)anchorSequence);
        ArrayList<List<SideFragment>> leftFragments = new ArrayList<List<SideFragment>>();
        IntPair leftOffsets = this.createLeftFragments(sequenceList, leftFragments, anchorRange.firstInt - 1, subSequenceStart);
        ArrayList<List<SideFragment>> rightFragments = new ArrayList<List<SideFragment>>();
        IntPair rightOffsets = this.createRightFragments(sequenceList, rightFragments, anchorRange.secondInt + 1, subSequenceEnd - 1);
        IntPair subSequenceOffsets = anchoredToEOF ? rightOffsets : leftOffsets;
        return new SubSequence(anchorMatcher, leftFragments, rightFragments, subSequenceOffsets.firstInt, subSequenceOffsets.secondInt);
    }

    private IntPair createLeftFragments(List<ParseTree> sequenceList, List<List<SideFragment>> leftFragments, int fragmentStart, int fragmentEnd) throws CompileException {
        int position = 1;
        int minGap = 0;
        int maxGap = 0;
        int startValueIndex = Integer.MAX_VALUE;
        int endValueIndex = Integer.MAX_VALUE;
        block5: for (int fragmentIndex = fragmentStart; fragmentIndex >= fragmentEnd; --fragmentIndex) {
            ParseTree node = sequenceList.get(fragmentIndex);
            switch (node.getParseTreeType()) {
                case BYTE: 
                case RANGE: 
                case STRING: 
                case ALL_BITMASK: 
                case SET: 
                case ANY: {
                    if (endValueIndex == Integer.MAX_VALUE) {
                        endValueIndex = fragmentIndex;
                    }
                    startValueIndex = fragmentIndex;
                    continue block5;
                }
                case REPEAT: 
                case REPEAT_MIN_TO_MAX: {
                    if (startValueIndex == fragmentIndex + 1) {
                        leftFragments.add(this.buildFragment(sequenceList, startValueIndex, endValueIndex, minGap, maxGap, position));
                        ++position;
                        minGap = 0;
                        maxGap = 0;
                        startValueIndex = Integer.MAX_VALUE;
                        endValueIndex = Integer.MAX_VALUE;
                    }
                    int nodeMin = this.getMinGap(node);
                    int nodeMax = this.getMaxGap(node);
                    if (nodeMax == 0) {
                        nodeMax = nodeMin;
                    }
                    minGap += nodeMin;
                    maxGap += nodeMax;
                    continue block5;
                }
                case ALTERNATIVES: {
                    if (startValueIndex == fragmentIndex + 1) {
                        leftFragments.add(this.buildFragment(sequenceList, startValueIndex, endValueIndex, minGap, maxGap, position));
                        ++position;
                        minGap = 0;
                        maxGap = 0;
                    }
                    leftFragments.add(this.compileAlternatives(node, minGap, maxGap, position));
                    ++position;
                    minGap = 0;
                    maxGap = 0;
                    startValueIndex = Integer.MAX_VALUE;
                    endValueIndex = Integer.MAX_VALUE;
                    continue block5;
                }
                default: {
                    throw new CompileException("Unknown node type: " + node + " found at node index: " + fragmentIndex);
                }
            }
        }
        if (startValueIndex == fragmentEnd) {
            leftFragments.add(this.buildFragment(sequenceList, startValueIndex, endValueIndex, minGap, maxGap, position));
            minGap = 0;
            maxGap = 0;
        }
        if (maxGap < minGap) {
            maxGap = minGap;
        }
        return new IntPair(minGap, maxGap);
    }

    private IntPair createRightFragments(List<ParseTree> sequenceList, List<List<SideFragment>> rightFragments, int fragmentStart, int fragmentEnd) throws CompileException {
        int position = 1;
        int minGap = 0;
        int maxGap = 0;
        int startValueIndex = Integer.MAX_VALUE;
        int endValueIndex = Integer.MAX_VALUE;
        block5: for (int fragmentIndex = fragmentStart; fragmentIndex <= fragmentEnd; ++fragmentIndex) {
            ParseTree node = sequenceList.get(fragmentIndex);
            switch (node.getParseTreeType()) {
                case BYTE: 
                case RANGE: 
                case STRING: 
                case ALL_BITMASK: 
                case SET: 
                case ANY: {
                    if (startValueIndex == Integer.MAX_VALUE) {
                        startValueIndex = fragmentIndex;
                    }
                    endValueIndex = fragmentIndex;
                    continue block5;
                }
                case REPEAT: 
                case REPEAT_MIN_TO_MAX: {
                    if (endValueIndex == fragmentIndex - 1) {
                        rightFragments.add(this.buildFragment(sequenceList, startValueIndex, endValueIndex, minGap, maxGap, position));
                        ++position;
                        minGap = 0;
                        maxGap = 0;
                        startValueIndex = Integer.MAX_VALUE;
                        endValueIndex = Integer.MAX_VALUE;
                    }
                    int nodeMin = this.getMinGap(node);
                    int nodeMax = this.getMaxGap(node);
                    if (nodeMax == 0) {
                        nodeMax = nodeMin;
                    }
                    minGap += nodeMin;
                    maxGap += nodeMax;
                    continue block5;
                }
                case ALTERNATIVES: {
                    if (endValueIndex == fragmentIndex - 1) {
                        rightFragments.add(this.buildFragment(sequenceList, startValueIndex, endValueIndex, minGap, maxGap, position));
                        ++position;
                        minGap = 0;
                        maxGap = 0;
                    }
                    rightFragments.add(this.compileAlternatives(node, minGap, maxGap, position));
                    ++position;
                    minGap = 0;
                    maxGap = 0;
                    startValueIndex = Integer.MAX_VALUE;
                    endValueIndex = Integer.MAX_VALUE;
                    continue block5;
                }
                default: {
                    throw new CompileException("Unknown node type: " + node + " found at node index: " + fragmentIndex);
                }
            }
        }
        if (endValueIndex == fragmentEnd) {
            rightFragments.add(this.buildFragment(sequenceList, startValueIndex, endValueIndex, minGap, maxGap, position));
            minGap = 0;
            maxGap = 0;
        }
        if (maxGap < minGap) {
            maxGap = minGap;
        }
        return new IntPair(minGap, maxGap);
    }

    private List<SideFragment> buildFragment(List<ParseTree> sequenceList, int startValueIndex, int endValueIndex, int minGap, int maxGap, int position) throws CompileException {
        ArrayList<SideFragment> fragments = new ArrayList<SideFragment>();
        ParseTree fragmentTree = this.createSubSequenceTree(sequenceList, startValueIndex, endValueIndex);
        SequenceMatcher matcher = (SequenceMatcher)MATCHER_COMPILER.compile((Object)fragmentTree);
        int minMax = maxGap < minGap ? minGap : maxGap;
        SideFragment fragment = new SideFragment(matcher, minGap, minMax, position);
        fragments.add(fragment);
        return fragments;
    }

    private ParseTree createSubSequenceTree(List<ParseTree> sequenceList, int subSequenceStart, int subSequenceEnd) {
        return new ChildrenNode(ParseTreeType.SEQUENCE, sequenceList.subList(subSequenceStart, subSequenceEnd + 1));
    }

    private List<SideFragment> compileAlternatives(ParseTree node, int minGap, int maxGap, int position) throws CompileException {
        int numChildren = node.getNumChildren();
        ArrayList<SideFragment> alternatives = new ArrayList<SideFragment>();
        for (int childIndex = 0; childIndex < numChildren; ++childIndex) {
            ParseTree alternative = node.getChild(childIndex);
            SequenceMatcher fragmentMatcher = (SequenceMatcher)MATCHER_COMPILER.compile((Object)alternative);
            int minMax = maxGap < minGap ? minGap : maxGap;
            SideFragment fragment = new SideFragment(fragmentMatcher, minGap, minMax, position);
            alternatives.add(fragment);
        }
        return alternatives;
    }

    private int getMinGap(ParseTree node) throws CompileException {
        if (node.getParseTreeType() == ParseTreeType.REPEAT || node.getParseTreeType() == ParseTreeType.REPEAT_MIN_TO_MAX) {
            try {
                return node.getNumChildren() > 0 ? node.getChild(0).getIntValue() : 0;
            }
            catch (ParseException ex) {
                throw new CompileException(ex.getMessage(), (Throwable)ex);
            }
        }
        return 0;
    }

    private int getMaxGap(ParseTree node) throws CompileException {
        if (node.getParseTreeType() == ParseTreeType.REPEAT_MIN_TO_MAX) {
            try {
                return node.getNumChildren() > 1 ? node.getChild(1).getIntValue() : 0;
            }
            catch (ParseException ex) {
                throw new CompileException(ex.getMessage(), (Throwable)ex);
            }
        }
        return 0;
    }

    private IntPair locateSearchSequence(List<ParseTree> sequence, int startIndex, int endIndex, CompileType compileType) throws CompileException {
        if (compileType == CompileType.PRONOM) {
            return this.locateSearchSequence(sequence, startIndex, endIndex, PRONOMStrategy);
        }
        IntPair result = this.locateSearchSequence(sequence, startIndex, endIndex, DROIDStrategy);
        if (result == NO_RESULT) {
            result = this.locateSearchSequence(sequence, startIndex, endIndex, AllowAllStrategy);
        }
        return result;
    }

    private IntPair locateSearchSequence(List<ParseTree> sequence, int startIndex, int endIndex, AnchorStrategy anchorStrategy) throws CompileException {
        int startPos = startIndex;
        int bestLength = 0;
        int bestStart = 0;
        int bestEnd = 0;
        block4: for (int childIndex = startIndex; childIndex < endIndex; ++childIndex) {
            ParseTree child = sequence.get(childIndex);
            switch (child.getParseTreeType()) {
                case RANGE: 
                case ALL_BITMASK: 
                case SET: 
                case ANY: {
                    if (anchorStrategy.canBePartOfAnchor(child)) continue block4;
                }
                case ALTERNATIVES: 
                case REPEAT: 
                case REPEAT_MIN_TO_MAX: {
                    int totalLength = this.calculateLength(sequence, startPos, childIndex - 1);
                    if (totalLength > bestLength) {
                        bestLength = totalLength;
                        bestStart = startPos;
                        bestEnd = childIndex - 1;
                    }
                    startPos = childIndex + 1;
                    continue block4;
                }
            }
        }
        int totalLength = this.calculateLength(sequence, startPos, endIndex - 1);
        if (totalLength > bestLength) {
            bestLength = totalLength;
            bestStart = startPos;
            bestEnd = endIndex - 1;
        }
        if (bestLength == 0) {
            return NO_RESULT;
        }
        return new IntPair(bestStart, bestEnd);
    }

    private int calculateLength(List<ParseTree> sequence, int startPos, int endPos) throws CompileException {
        int totalLength = 0;
        try {
            block7: for (int index = startPos; index <= endPos; ++index) {
                ParseTree node = sequence.get(index);
                switch (node.getParseTreeType()) {
                    case BYTE: 
                    case RANGE: 
                    case ALL_BITMASK: 
                    case SET: 
                    case ANY: {
                        ++totalLength;
                        continue block7;
                    }
                    case STRING: {
                        totalLength += node.getTextValue().length();
                        continue block7;
                    }
                    case REPEAT: {
                        totalLength += node.getChild(0).getIntValue();
                        continue block7;
                    }
                    default: {
                        throw new CompileException("Could not calculate length of node " + node);
                    }
                }
            }
        }
        catch (ParseException e) {
            throw new CompileException(e.getMessage(), (Throwable)e);
        }
        return totalLength;
    }

    private static int countMatchingBitmask(ParseTree node) throws ParseException {
        return ByteUtils.countBytesMatchingAllBits((byte)node.getByteValue());
    }

    private static int countMatchingSet(ParseTree node) throws ParseException {
        return ParseTreeUtils.calculateSetValues((ParseTree)node).size();
    }

    private static int countMatchingRange(ParseTree rangeNode) throws CompileException {
        if (rangeNode.getParseTreeType() == ParseTreeType.RANGE) {
            int range2;
            int range1;
            try {
                range1 = rangeNode.getChild(0).getIntValue();
                range2 = rangeNode.getChild(1).getIntValue();
            }
            catch (ParseException e) {
                throw new CompileException(e.getMessage(), (Throwable)e);
            }
            return range2 > range1 ? range2 - range1 : range1 - range2;
        }
        throw new IllegalArgumentException("Parse tree node is not a RANGE type: " + rangeNode);
    }

    private static class AllowAllAnchorStrategy
    implements AnchorStrategy {
        private AllowAllAnchorStrategy() {
        }

        @Override
        public boolean canBePartOfAnchor(ParseTree node) throws CompileException {
            return true;
        }
    }

    private static class DROIDAnchorStrategy
    implements AnchorStrategy {
        private DROIDAnchorStrategy() {
        }

        @Override
        public boolean canBePartOfAnchor(ParseTree node) throws CompileException {
            ParseTreeType type = node.getParseTreeType();
            try {
                return type == ParseTreeType.RANGE && ByteSequenceCompiler.countMatchingRange(node) <= 64 || type == ParseTreeType.SET && ByteSequenceCompiler.countMatchingSet(node) <= 64 || type == ParseTreeType.ALL_BITMASK && ByteSequenceCompiler.countMatchingBitmask(node) <= 64;
            }
            catch (ParseException e) {
                throw new CompileException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class PRONOMAnchorStrategy
    implements AnchorStrategy {
        private PRONOMAnchorStrategy() {
        }

        @Override
        public boolean canBePartOfAnchor(ParseTree node) throws CompileException {
            return false;
        }
    }

    private static interface AnchorStrategy {
        public boolean canBePartOfAnchor(ParseTree var1) throws CompileException;
    }

    private static class IntIterator {
        private final int stopValue;
        private final int increment;
        private int position;

        public IntIterator(int start, int end) {
            if (start < 0 || end < 0) {
                this.position = 0;
                this.increment = 0;
                this.stopValue = 0;
            } else {
                this.position = start;
                this.increment = start < end ? 1 : -1;
                this.stopValue = end + this.increment;
            }
        }

        public boolean hasNext() {
            return this.position != this.stopValue;
        }

        public int next() {
            if (this.hasNext()) {
                int currentPosition = this.position;
                this.position += this.increment;
                return currentPosition;
            }
            throw new NoSuchElementException("Iterator has position: " + this.position + " stopValue: " + this.stopValue + " and increment " + this.increment);
        }
    }

    private static class IntPair {
        final int firstInt;
        final int secondInt;

        public IntPair(int firstInt, int secondInt) {
            this.firstInt = firstInt;
            this.secondInt = secondInt;
        }
    }

    public static enum CompileType {
        PRONOM,
        DROID;

    }
}

