/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.util.file;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.MetadataProviderDROID;
import ch.docuteam.tools.out.Logger;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NormalizedFileName {
    private final String original;
    private String normalized;
    private String extension;
    private final NodeAbstract metsNode;

    public NormalizedFileName(NodeAbstract metsNode) {
        this.metsNode = metsNode;
        this.original = metsNode.getLabel();
        this.normalized = metsNode.getLabel();
        if (metsNode.isFile() && this.original.lastIndexOf(".") != -1) {
            this.normalized = FileUtil.asFileNameWithoutExtension((String)this.original);
            this.extension = FileUtil.asFileNameExtension((String)this.original);
        }
    }

    String getOriginal() {
        return this.original;
    }

    String getNormalized() {
        return this.normalized;
    }

    String getExtension() {
        return this.extension;
    }

    void setExtension(String extension) {
        this.extension = extension;
    }

    NodeAbstract getMetsNode() {
        return this.metsNode;
    }

    void setNormalized(String normalizedFileName) {
        this.normalized = normalizedFileName;
    }

    boolean isFileNameNormalized() {
        String newFileName = this.normalized;
        return !this.getOriginal().equals(newFileName);
    }

    NormalizedFileName replaceForbiddenChars(Map<String, String> charConversionMap) {
        for (String convertibleString : charConversionMap.keySet()) {
            String mappedString = charConversionMap.get(convertibleString);
            Pattern pattern = Pattern.compile(convertibleString);
            Matcher matcher = pattern.matcher(this.normalized);
            this.normalized = matcher.replaceAll(mappedString);
        }
        return this;
    }

    NormalizedFileName addPrefix(String prefix) {
        if (!prefix.isEmpty() && !this.normalized.startsWith(prefix)) {
            this.normalized = prefix + this.normalized;
        }
        return this;
    }

    NormalizedFileName addSuffix(String suffix) {
        if (!suffix.isEmpty() && !this.normalized.endsWith(suffix)) {
            this.normalized = this.normalized + suffix;
        }
        return this;
    }

    NormalizedFileName trimToMaxLength(int maxLength, String prefix, String suffix) {
        if (maxLength > 0) {
            String oldNormalize = this.normalized;
            String newNormalized = this.addPrefix(prefix).addSuffix(suffix).getNormalized();
            int newLength = Math.min(maxLength, newNormalized.length());
            if (newNormalized.length() > newLength) {
                int removableLength = newNormalized.length() - newLength;
                this.normalized = newNormalized = oldNormalize.substring(0, oldNormalize.length() - removableLength);
            } else {
                this.normalized = oldNormalize;
            }
        }
        return this;
    }

    NormalizedFileName addExtension() {
        if (this.metsNode instanceof NodeFile) {
            String correctExtension = this.getCorrectExtension(this.extension);
            if (correctExtension != null) {
                this.extension = correctExtension;
            }
            if (this.extension != null) {
                this.normalized = this.normalized + "." + this.extension;
            }
        }
        return this;
    }

    String getCorrectExtension(String originalExtension) {
        if (this.metsNode == null) {
            return null;
        }
        String correctExtension = null;
        try {
            List possibleExtensions = MetadataProviderDROID.getExtensions((String)this.metsNode.getFormatKey());
            if (originalExtension != null && possibleExtensions.contains(originalExtension.toLowerCase())) {
                correctExtension = originalExtension;
            } else if (possibleExtensions.size() > 0) {
                correctExtension = (String)possibleExtensions.get(0);
            }
        }
        catch (Exception e) {
            Logger.error((Object)"getCorrectExtension failed: ", (Throwable)e);
        }
        return correctExtension;
    }

    NormalizedFileName addUniqueId(Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        if (!this.isValueInMapForASibling(this.metsNode, nodesToUniqueFileNamesMap, this.normalized)) {
            nodesToUniqueFileNamesMap.put(this.metsNode, this.normalized);
            return this;
        }
        this.normalized = FileUtil.createUniqueFileNameByAppendingUniqueId((String)this.normalized, nodesToUniqueFileNamesMap.values());
        nodesToUniqueFileNamesMap.put(this.metsNode, this.normalized);
        return this;
    }

    private boolean isValueInMapForASibling(NodeAbstract metsStructMapNode, Map<NodeAbstract, String> nodesToUniqueFileNamesMap, String suggestedName) {
        boolean isSuggestedNameAlreadyUsed = nodesToUniqueFileNamesMap.containsValue(suggestedName);
        boolean isNameUsedByASibling = false;
        if (isSuggestedNameAlreadyUsed) {
            for (NodeAbstract node : nodesToUniqueFileNamesMap.keySet()) {
                String name = nodesToUniqueFileNamesMap.get(node);
                if (!name.equals(suggestedName) || !metsStructMapNode.getParent().equals(node.getParent())) continue;
                isNameUsedByASibling = true;
            }
        }
        return isNameUsedByASibling;
    }
}

