/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class OctetCharset
extends Charset {
    protected static final char REPLACEMENT = '\ufffd';
    private final char[] byte2char;
    private final char[][] char2byte;

    protected OctetCharset(String cname, String[] aliases, char[] byte2char) {
        aliases = (String[])aliases.clone();
        super(cname, aliases);
        byte2char = (char[])byte2char.clone();
        char[][] char2byte = new char[256][];
        for (int i = 0; i < 256; i = (int)((char)(i + 1))) {
            char c = byte2char[i];
            if (c == '\ufffd') continue;
            int hi = c >>> 8;
            int lo = c & 0xFF;
            char[] table = char2byte[hi];
            if (table == null) {
                table = new char[256];
                Arrays.fill(table, '\ufffd');
                char2byte[hi] = table;
            }
            table[lo] = i;
        }
        this.byte2char = byte2char;
        this.char2byte = char2byte;
    }

    @Override
    public boolean contains(Charset cs) {
        return this.getClass().isInstance(cs);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    private class Decoder
    extends CharsetDecoder {
        Decoder() {
            super(OctetCharset.this, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            char[] b2c = OctetCharset.this.byte2char;
            while (in.hasRemaining()) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c = b2c[in.get() & 0xFF];
                if (c == '\ufffd') {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put(c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private class Encoder
    extends CharsetEncoder {
        Encoder() {
            super(OctetCharset.this, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            char[][] c2b = OctetCharset.this.char2byte;
            while (in.hasRemaining()) {
                char b;
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                int hi = c >>> 8;
                int lo = c & 0xFF;
                char[] table = c2b[hi];
                if (table == null || (b = table[lo]) == '\ufffd') {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put((byte)b);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

