/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.automata.regex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.byteseek.automata.Automata;
import net.byteseek.automata.MutableAutomata;
import net.byteseek.automata.State;
import net.byteseek.automata.Transition;
import net.byteseek.automata.factory.MutableStateFactory;
import net.byteseek.automata.factory.StateFactory;
import net.byteseek.automata.factory.TransitionFactory;
import net.byteseek.automata.regex.RegexBuilder;
import net.byteseek.utils.ArgUtils;

public final class GlushkovRegexBuilder<T, S>
implements RegexBuilder<T, S> {
    private final TransitionFactory<T, S> transitionFactory;
    private final StateFactory<T> stateFactory;

    public GlushkovRegexBuilder(TransitionFactory<T, S> transitionFactory) {
        this(transitionFactory, null);
    }

    public GlushkovRegexBuilder(TransitionFactory<T, S> transitionFactory, StateFactory<T> stateFactory) {
        ArgUtils.checkNullObject(transitionFactory, "transitionFactory");
        this.transitionFactory = transitionFactory;
        this.stateFactory = stateFactory == null ? new MutableStateFactory() : stateFactory;
    }

    @Override
    public Automata<T> buildTransitionAutomata(S source, boolean inverted) {
        State<T> initialState = this.stateFactory.create(false);
        State<T> finalState = this.stateFactory.create(true);
        Transition<T> transition = this.transitionFactory.create(source, inverted, finalState);
        initialState.addTransition(transition);
        return new MutableAutomata<T>(initialState);
    }

    @Override
    public Automata<T> buildSequenceAutomata(List<Automata<T>> automataSequence) {
        ArrayList<State<T>> finalStates = new ArrayList<State<T>>();
        int stop = automataSequence.size();
        for (int automataIndex = 1; automataIndex < stop; ++automataIndex) {
            Automata<T> leftAutomata = automataSequence.get(automataIndex - 1);
            finalStates.addAll(leftAutomata.getFinalStates());
            Automata<T> rightAutomata = automataSequence.get(automataIndex);
            State<T> rightInitialState = rightAutomata.getInitialState();
            boolean rightInitialStateIsFinal = rightInitialState.isFinal();
            for (State state : finalStates) {
                state.addAllTransitions(rightInitialState.iterator());
                state.setIsFinal(rightInitialStateIsFinal);
            }
            if (rightInitialStateIsFinal) continue;
            finalStates.clear();
        }
        return automataSequence.get(0);
    }

    @Override
    public Automata<T> buildAlternativesAutomata(List<Automata<T>> alternateAutomata) {
        Automata<T> initialAutomata = alternateAutomata.get(0);
        State<T> initialState = initialAutomata.getInitialState();
        boolean isFinal = initialState.isFinal();
        int stop = alternateAutomata.size();
        for (int automataIndex = 1; automataIndex < stop; ++automataIndex) {
            Automata<T> nextAutomata = alternateAutomata.get(automataIndex);
            State<T> nextInitialState = nextAutomata.getInitialState();
            isFinal |= nextInitialState.isFinal();
            initialState.addAllTransitions(nextInitialState.iterator());
        }
        initialState.setIsFinal(isFinal);
        return initialAutomata;
    }

    @Override
    public Automata<T> buildZeroToManyAutomata(Automata<T> zeroToMany) {
        State<T> initialState = zeroToMany.getInitialState();
        Collection<State<T>> finalStates = zeroToMany.getFinalStates();
        for (State<T> state : finalStates) {
            state.addAllTransitions(initialState.iterator());
        }
        initialState.setIsFinal(true);
        return zeroToMany;
    }

    @Override
    public Automata<T> buildOneToManyAutomata(Automata<T> oneToMany) {
        State<T> initialState = oneToMany.getInitialState();
        Collection<State<T>> finalStates = oneToMany.getFinalStates();
        for (State<T> state : finalStates) {
            state.addAllTransitions(initialState.iterator());
        }
        return oneToMany;
    }

    @Override
    public Automata<T> buildOptionalAutomata(Automata<T> optional) {
        optional.getInitialState().setIsFinal(true);
        return optional;
    }

    @Override
    public Automata<T> buildMinToManyAutomata(int minRepeat, Automata<T> repeatedAutomata) {
        Automata<T> automata = null;
        if (minRepeat == 0) {
            automata = this.buildZeroToManyAutomata(repeatedAutomata);
        } else if (minRepeat > 0) {
            Automata<T> repeatStates = this.buildRepeatedAutomata(minRepeat, repeatedAutomata);
            Automata<T> zeroToManyStates = this.buildZeroToManyAutomata(repeatedAutomata.deepCopy());
            automata = this.joinAutomata(repeatStates, zeroToManyStates);
        }
        return automata;
    }

    @Override
    public Automata<T> buildMinToMaxAutomata(int minRepeat, int maxRepeat, Automata<T> repeatedAutomata) {
        Automata<T> automata;
        if (minRepeat == 0) {
            automata = this.buildRepeatedOptionalAutomata(maxRepeat, repeatedAutomata);
        } else {
            automata = this.buildRepeatedAutomata(minRepeat, repeatedAutomata);
            if (maxRepeat > minRepeat) {
                Automata<T> optionalStates = this.buildRepeatedOptionalAutomata(maxRepeat - minRepeat, repeatedAutomata);
                automata = this.joinAutomata(automata, optionalStates);
            }
        }
        return automata;
    }

    @Override
    public Automata<T> buildRepeatedOptionalAutomata(int numberOptional, Automata<T> optional) {
        ArrayList<Automata<T>> automataList = new ArrayList<Automata<T>>();
        for (int count = 0; count < numberOptional; ++count) {
            Automata<T> optStates = this.buildOptionalAutomata(optional.deepCopy());
            automataList.add(optStates);
        }
        return this.buildSequenceAutomata(automataList);
    }

    @Override
    public Automata<T> buildRepeatedAutomata(int repeatNumber, Automata<T> repeatedAutomata) {
        ArrayList<Automata<T>> automataList = new ArrayList<Automata<T>>();
        for (int count = 0; count < repeatNumber; ++count) {
            Automata<T> newAutomata = repeatedAutomata.deepCopy();
            automataList.add(newAutomata);
        }
        return this.buildSequenceAutomata(automataList);
    }

    private Automata<T> joinAutomata(Automata<T> leftAutomata, Automata<T> rightAutomata) {
        ArrayList<Automata<T>> joinedAutomata = new ArrayList<Automata<T>>(2);
        joinedAutomata.add(leftAutomata);
        joinedAutomata.add(rightAutomata);
        return this.buildSequenceAutomata(joinedAutomata);
    }
}

