/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.automata;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.byteseek.automata.Automata;
import net.byteseek.automata.State;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.MatchResult;
import net.byteseek.matcher.automata.AutomataMatcher;

public final class NfaMatcher<T>
implements AutomataMatcher<T> {
    private final Automata<T> automata;

    public NfaMatcher(Automata<T> automata) {
        this.automata = automata;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        long currentPosition = matchPosition;
        LinkedHashSet nextStates = new LinkedHashSet();
        LinkedHashSet<State<T>> activeStates = new LinkedHashSet<State<T>>();
        activeStates.add(this.automata.getInitialState());
        Window window = reader.getWindow(currentPosition);
        while (window != null) {
            int windowStart;
            byte[] bytes = window.getArray();
            int windowLength = window.length();
            int windowPos = windowStart = reader.getWindowOffset(currentPosition);
            while (!activeStates.isEmpty() && windowPos < windowLength) {
                for (State state : activeStates) {
                    if (!state.isFinal()) continue;
                    return true;
                }
                byte currentByte = bytes[windowPos++];
                for (State currentState3 : activeStates) {
                    currentState3.appendNextStates(nextStates, currentByte);
                }
                LinkedHashSet<State<T>> linkedHashSet = activeStates;
                activeStates = nextStates;
                nextStates = linkedHashSet;
                nextStates.clear();
            }
            window = reader.getWindow(currentPosition += (long)(windowLength - windowStart));
        }
        return false;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        int length = bytes.length;
        if (matchPosition >= 0 && matchPosition < length) {
            int currentPosition = matchPosition;
            LinkedHashSet nextStates = new LinkedHashSet();
            LinkedHashSet<State<T>> activeStates = new LinkedHashSet<State<T>>();
            activeStates.add(this.automata.getInitialState());
            while (!activeStates.isEmpty() && currentPosition < length) {
                for (State state : activeStates) {
                    if (!state.isFinal()) continue;
                    return true;
                }
                byte currentByte = bytes[currentPosition++];
                for (State currentState3 : activeStates) {
                    currentState3.appendNextStates(nextStates, currentByte);
                }
                LinkedHashSet<State<T>> linkedHashSet = activeStates;
                activeStates = nextStates;
                nextStates = linkedHashSet;
                nextStates.clear();
            }
        }
        return false;
    }

    @Override
    public MatchResult<T> firstMatch(WindowReader reader, long matchPosition) throws IOException {
        return null;
    }

    @Override
    public MatchResult<T> nextMatch(WindowReader reader, MatchResult<T> lastMatch) throws IOException {
        return null;
    }

    @Override
    public Collection<MatchResult<T>> allMatches(WindowReader reader, long matchPosition) throws IOException {
        return null;
    }

    @Override
    public MatchResult<T> firstMatch(byte[] bytes, int matchPosition) {
        return null;
    }

    @Override
    public MatchResult<T> nextMatch(byte[] bytes, MatchResult<T> lastMatch) {
        return null;
    }

    @Override
    public Collection<MatchResult<T>> allMatches(byte[] bytes, int matchPosition) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[automata:" + this.automata + ']';
    }
}

