/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.DbotMessageData;
import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;

public class DbotClient {
    private static final ExLogger logger = ExLogger.getExLogger(DbotClient.class);
    private static QueueConnection cnn = null;
    private static QueueSender sender = null;
    private static Queue queue = null;

    private static void init() {
        try {
            if (cnn == null || sender == null || queue == null) {
                InitialContext ctx = new InitialContext();
                queue = (Queue)ctx.lookup("queue/dbot");
                QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("ConnectionFactory");
                cnn = factory.createQueueConnection();
            }
        }
        catch (Exception e) {
            logger.error("JMSClient" + e.getStackTrace(), new String[0]);
        }
    }

    public static void execute(String dfName, String size, String units, String username, String password) {
        QueueSession sess = null;
        DbotMessageData messageData = new DbotMessageData();
        messageData.setDfName(dfName);
        messageData.setSize(size);
        messageData.setUnits(units);
        messageData.setUsername(username);
        messageData.setPassword(password);
        try {
            DbotClient.init();
            sess = cnn.createQueueSession(false, 1);
            ObjectMessage msg = sess.createObjectMessage((Serializable)messageData);
            sender = sess.createSender(queue);
            sender.send((Message)msg);
            sess.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

