/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.locator;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.locator.HibernateSessionRetrieverHelper;
import org.hibernate.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ServiceLocator {
    private static ExLogger log = ExLogger.getExLogger(ServiceLocator.class);
    private ApplicationContext applicationContext;
    private static ServiceLocator ourInstance;

    public static ServiceLocator getInstance() {
        if (ourInstance == null) {
            ourInstance = new ServiceLocator();
        }
        return ourInstance;
    }

    private ServiceLocator() {
        this.init();
    }

    public void reset() {
        this.init();
    }

    private void init() {
        this.applicationContext = new ClassPathXmlApplicationContext(new String[]{"META-INF/spring/app-context.xml"}, false);
        log.info("Start scanning Jars for Spring Beans: ");
        ((ConfigurableApplicationContext)this.applicationContext).refresh();
        log.info("Done scanning Jars for Spring Beans.");
    }

    public <T> T lookUp(Class T) {
        return this.lookUp(T.getSimpleName(), T);
    }

    public <T> T lookUp(String lookupName, Class T) {
        return (T)this.applicationContext.getBean(lookupName + "/local", T);
    }

    public Session getRosCurentSession() {
        HibernateSessionRetrieverHelper helperDao = (HibernateSessionRetrieverHelper)this.lookUp(HibernateSessionRetrieverHelper.class);
        return helperDao.getCurrentSession();
    }
}

