/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.plugins;

import com.exlibris.core.infra.common.config.EventMD;
import com.exlibris.core.infra.common.security.UserPrincipal;
import com.exlibris.core.infra.model.HFrEvent;
import com.exlibris.core.infra.model.plugins.PluginImplType;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.common.msgQueue.EventMsgClient;
import com.exlibris.core.infra.svc.api.config.EventFactory;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.plugins.Plugin;
import com.exlibris.core.infra.svc.api.plugins.PluginParameters;
import com.exlibris.core.infra.svc.api.plugins.PluginResult;
import com.exlibris.core.infra.svc.api.plugins.PluginScriptRunner;
import java.util.HashMap;
import java.util.List;

@Deprecated
public abstract class AbstractPlugin
implements Plugin {
    private String name;
    private PluginImplType pluginImplType;
    private String pluginId;
    private EventMD initializedEvent = EventFactory.PLUGIN_INITIALIZED;
    private EventMD executedEvent = EventFactory.PLUGIN_EXECUTED;
    private EventMD executionCompleteEvent = EventFactory.PLUGIN_EXECUTION_COMPLETE;
    private GeneralParameterManager gpManager = null;

    public AbstractPlugin() {
    }

    public AbstractPlugin(String name, PluginImplType pluginImplType) {
        this.name = name;
        this.pluginImplType = pluginImplType;
    }

    public PluginResult execute(PluginParameters parameters, UserPrincipal userPrincipal) {
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("PLUGIN_NAME", this.getName());
        eventParams.put("PLUGIN_ID", this.getPluginId());
        this.sendEvent(userPrincipal, this.getExecutedEvent(), eventParams);
        PluginResult rtn = null;
        rtn = PluginImplType.SCRIPT.equals((Object)this.pluginImplType) ? this.executeScript(parameters) : this.innerExecute(parameters);
        String msg = null;
        Exception e = rtn.getException();
        if (null != e) {
            msg = e.getMessage();
        }
        eventParams = this.populateExecuteEventParameters(this.getName(), this.getPluginId(), msg);
        this.sendEvent(userPrincipal, this.getExecutionCompleteEvent(), eventParams);
        return rtn;
    }

    protected HashMap<String, String> populateExecuteEventParameters(String pluginName, String pluginId, String exceptionMsg) {
        HashMap<String, String> rtn = new HashMap<String, String>();
        rtn.put("PLUGIN_NAME", pluginName);
        rtn.put("PLUGIN_ID", pluginId);
        rtn.put("EXCEPTION_TEXT", exceptionMsg);
        return rtn;
    }

    protected PluginResult executeScript(PluginParameters parameters) {
        List<String> command = this.convertParametersToCommandList(parameters);
        PluginScriptRunner runner = new PluginScriptRunner();
        PluginResult result = runner.execute(command);
        return result;
    }

    protected void sendEvent(UserPrincipal userPrincipal, EventMD eventMD, HashMap<String, String> paramMap) {
        EventFactory eventFactory = EventFactory.getInstance();
        HFrEvent event = eventFactory.createEvent(eventMD, userPrincipal, paramMap);
        EventMsgClient.sendEvent(event);
    }

    public abstract void init(PluginParameters var1, UserPrincipal var2);

    protected abstract PluginResult innerExecute(PluginParameters var1);

    protected abstract List<String> convertParametersToCommandList(PluginParameters var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public PluginImplType getPluginImplType() {
        return this.pluginImplType;
    }

    @Override
    public void setPluginImplType(PluginImplType pluginImplType) {
        this.pluginImplType = pluginImplType;
    }

    public EventMD getInitializedEvent() {
        return this.initializedEvent;
    }

    public void setInitializedEvent(EventMD initializedEvent) {
        this.initializedEvent = initializedEvent;
    }

    public EventMD getExecutedEvent() {
        return this.executedEvent;
    }

    public void setExecutedEvent(EventMD executedEvent) {
        this.executedEvent = executedEvent;
    }

    public GeneralParameterManager getGpManager() {
        if (null == this.gpManager) {
            this.gpManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        }
        return this.gpManager;
    }

    public void setGpManager(GeneralParameterManager gpManager) {
        this.gpManager = gpManager;
    }

    public EventMD getExecutionCompleteEvent() {
        return this.executionCompleteEvent;
    }

    public void setExecutionCompleteEvent(EventMD executionCompleteEvent) {
        this.executionCompleteEvent = executionCompleteEvent;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }
}

