/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.storage;

import com.exlibris.core.infra.model.rules.HFrRuleParam;
import com.exlibris.core.infra.model.storage.Storage;
import com.exlibris.core.infra.svc.api.RulesManager;
import com.exlibris.core.infra.svc.api.locator.PluginLocator;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.services.storage.StorageService;
import com.exlibris.core.sdk.storage.containers.StoredEntityMetaData;
import com.exlibris.core.sdk.storage.handler.StorageHandler;
import com.exlibris.core.sdk.storage.svc.StorageCacheManager;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxRuleBridge;
import com.exlibris.digitool.rules.enums.STORE_META_DATA_IN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StorageHandlerLocator {
    private static StorageHandlerLocator storageHandlerLocator;

    public static StorageHandlerLocator getInstance() {
        if (storageHandlerLocator == null) {
            storageHandlerLocator = new StorageHandlerLocator();
        }
        return storageHandlerLocator;
    }

    public StorageHandler getStorageHandlerByDnx(String ruleType, StoredEntityMetaData storedEntityMetadata) throws Exception {
        List<HFrRuleParam> outParams;
        ArrayList<DnxDocument> dnxs = new ArrayList<DnxDocument>();
        if (storedEntityMetadata.getIeDnx() != null) {
            dnxs.add(storedEntityMetadata.getIeDnx());
        }
        if (storedEntityMetadata.getRepDnx() != null) {
            dnxs.add(storedEntityMetadata.getRepDnx());
        }
        if (storedEntityMetadata.getFileDnx() != null) {
            dnxs.add(storedEntityMetadata.getFileDnx());
        }
        if (storedEntityMetadata.getExtraDnxs() != null) {
            dnxs.addAll(storedEntityMetadata.getExtraDnxs());
        }
        if ((outParams = DnxRuleBridge.runRuleEngine(ruleType, dnxs.toArray(new DnxDocument[dnxs.size()]))) != null) {
            Long storageGroupId = Long.parseLong(outParams.get(0).getValue());
            return this.getHandlerByStorageGroup(storageGroupId, storedEntityMetadata);
        }
        throw new IllegalArgumentException("No rule match " + ruleType);
    }

    public StorageHandler getMDStorageHandler(String mdType, StoredEntityMetaData storedEntityMetaData) throws Exception {
        RulesManager rulesManager = (RulesManager)ServiceLocator.getInstance().lookUp(RulesManager.class);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(STORE_META_DATA_IN.metadataType.name(), mdType);
        List<HFrRuleParam> outParams = rulesManager.getMatchingRuleOutputForAllInstitution("STORE_META_DATA", values);
        if (outParams.size() > 0) {
            Long storageGroupId = Long.parseLong(outParams.get(0).getValue());
            return this.getHandlerByStorageGroup(storageGroupId, storedEntityMetaData);
        }
        throw new IllegalArgumentException("No rule match STORE_META_DATA");
    }

    public static StorageHandler getStorageHandlerByStorageId(Long storageId) {
        StorageHandler storageHandler = StorageCacheManager.getInstance().getStorageHandler(storageId);
        if (storageHandler == null) {
            StorageService storageService = (StorageService)ServiceLocator.getInstance().lookUp(StorageService.class);
            Storage storage = storageService.getStorageById(storageId);
            storageHandler = StorageHandlerLocator.getStorageHandler(storage);
            StorageCacheManager.getInstance().addStorageHandler(storage, storageHandler);
        }
        return storageHandler;
    }

    private StorageHandler getHandlerByStorageGroup(Long storageGroupId, StoredEntityMetaData storedEntityMetaData) throws Exception {
        StorageService storageService = (StorageService)ServiceLocator.getInstance().lookUp(StorageService.class);
        Storage storage = storageService.selectStorage(storageGroupId, storedEntityMetaData.getSizeInBytes());
        StorageHandler storageHandler = StorageCacheManager.getInstance().getStorageHandler(storage.getId());
        if (storageHandler == null) {
            storageHandler = StorageHandlerLocator.getStorageHandler(storage);
            StorageCacheManager.getInstance().addStorageHandler(storage, storageHandler);
        }
        return storageHandler;
    }

    private static StorageHandler getStorageHandler(Storage storage) {
        StorageHandler handler = null;
        try {
            String handlerName = storage.getPluginInstanceName();
            handler = (StorageHandler)PluginLocator.getInstance().lookUp(StorageHandler.class, handlerName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        handler.init(storage.getStorageParamAsMap());
        handler.setStorageId(storage.getId());
        handler.setStorageGroupId(storage.getGroup().getId());
        return handler;
    }
}

