/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.config;

import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SetSSL {
    static String mngEar;
    static String[] modulesInAll;
    static String[] modules;

    public static void main(String[] args) {
        mngEar = FSUtil.getDeployDir() + "digitool-mng.ear" + File.separator;
        if (args == null || args.length < 1) {
            SetSSL.usage();
            return;
        }
        String module = args[0];
        if ("report".equals(module)) {
            SetSSL.getCurrentSettings();
            return;
        }
        boolean setssl = Boolean.valueOf(args[1]);
        if (setssl) {
            SetSSL.setGeneralServerSSL(setssl);
        }
        if (module.equalsIgnoreCase("ALL")) {
            SetSSL.setGeneralServerSSL(setssl);
            for (int i = 0; i < modulesInAll.length; ++i) {
                String mod = modulesInAll[i];
                SetSSL.setModuleSSL(mod, setssl);
            }
        } else {
            SetSSL.setModuleSSL(module, setssl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setGeneralServerSSL(boolean setssl) {
        String fileStr;
        File serverXml = new File(FSUtil.getDeployDir() + "jbossweb-tomcat.sar" + File.separator + "server.xml");
        String newXml = fileStr = FileUtil.getContents(serverXml);
        if (setssl) {
            newXml = fileStr.replaceAll("<!--[^<]*ssl_comment_start[^<]*--><!--", "<!--ssl_comment_start-->");
            newXml = newXml.replaceAll("--><!--[^<]*ssl_comment_end[^<]*-->", "<!--ssl_comment_end-->");
        } else {
            newXml = fileStr.replaceAll("<!--[^<]*ssl_comment_start[^<]*-->", "<!--ssl_comment_start--><!--");
            newXml = newXml.replaceAll("<!--[^<]*ssl_comment_end[^<]*-->", "--><!--ssl_comment_end-->");
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(serverXml));
            out.write(newXml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (setssl) {
            System.out.println("SSL/TLS Connector configuration in server.xml is enabled");
        } else {
            System.out.println("SSL/TLS Connector configuration in server.xml is disabled");
        }
    }

    private static void getCurrentSettings() {
        System.out.println("Current settings:");
        for (int i = 0; i < modules.length; ++i) {
            String mod = modules[i];
            SetSSL.getCurrentSettings(mod);
        }
    }

    private static void getCurrentSettings(String module) {
        File moduleWebXml = new File(mngEar + "digitool-" + module + ".war" + File.separator + "WEB-INF" + File.separator + "web.xml");
        if (!moduleWebXml.exists()) {
            System.out.println(moduleWebXml.getAbsolutePath() + " not exists");
            return;
        }
        String fileStr = FileUtil.getContents(moduleWebXml);
        if (fileStr.indexOf("<transport-guarantee>CONFIDENTIAL") > -1) {
            System.out.println(module + " - enabled");
            return;
        }
        if (fileStr.indexOf("<transport-guarantee>NONE") > -1) {
            System.out.println(module + " - disabled");
            return;
        }
        System.out.println(module + " - unknown");
    }

    private static void setModuleSSL(String module, boolean setssl) {
        File moduleWebXml = new File(mngEar + "digitool-" + module + ".war" + File.separator + "WEB-INF" + File.separator + "web.xml");
        if (!moduleWebXml.exists()) {
            System.out.println(moduleWebXml.getAbsolutePath() + " not exists");
            return;
        }
        String fileStr = FileUtil.getContents(moduleWebXml);
        if (fileStr.indexOf("<transport-guarantee>") == -1) {
            System.out.println("could not find - <transport-guarantee> in " + moduleWebXml.getAbsolutePath());
            System.out.println("SSL is disabled for module " + module);
            return;
        }
        String newXml = fileStr;
        newXml = setssl ? fileStr.replaceAll("<transport-guarantee>[^<]*</transport-guarantee>", "<transport-guarantee>CONFIDENTIAL</transport-guarantee>") : fileStr.replaceAll("<transport-guarantee>[^<]*</transport-guarantee>", "<transport-guarantee>NONE</transport-guarantee>");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(moduleWebXml));
            out.write(newXml);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (setssl) {
            System.out.println("SSL is enabled for module " + module);
        } else {
            System.out.println("SSL is disabled for module " + module);
        }
    }

    private static void usage() {
        System.out.println("usage:");
        System.out.println("SetSSL report - to see current settings");
        System.out.println("SetSSL <module_name/ALL> <true/false>");
        System.out.println("e.g. enable SSL for mng module - SetSSL mng true");
        System.out.println("e.g. disable SSL for all modules - SetSSL ALL false");
        System.out.println("Available modules : ");
        System.out.println("(included in - ALL) ");
        for (int i = 0; i < modulesInAll.length; ++i) {
            String mn = modulesInAll[i];
            System.out.println(mn);
        }
        System.out.println("(not included) ");
        System.out.println("collection");
    }

    static {
        modulesInAll = new String[]{"approver", "deposit", "j2k", "metsviewer", "mng", "view", "webclient", "webingest"};
        modules = new String[]{"approver", "collection", "deposit", "j2k", "metsviewer", "mng", "view", "webclient", "webingest"};
    }
}

