/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.delivery;

import com.exlibris.core.infra.model.HPersistent;
import com.exlibris.core.infra.model.annotation.Searchable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Transient;

@Entity
@NamedQueries(value={@NamedQuery(name="isNameExist", query="select count(id) from DeliveryViewer where name =:name and id !=:id"), @NamedQuery(name="GET_DEFAULT_VIEWER", query="select dv from DeliveryViewer dv where dv.id = :id")})
public class DeliveryViewer
extends HPersistent {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private String vppPluginName;
    private String url;
    private Type viewerType;
    private Level viewerLevel;
    private String viewerLevelStr;
    private String indexXml;

    public DeliveryViewer(DeliveryViewer oldViewer) {
        this.name = "Copy of " + oldViewer.getName();
        this.description = oldViewer.getDescription();
        this.vppPluginName = oldViewer.getVppPluginName();
        this.url = oldViewer.getUrl();
        this.viewerType = oldViewer.getType();
        this.viewerLevel = oldViewer.getViewerLevel();
    }

    public DeliveryViewer() {
    }

    @Column
    @Searchable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(length=4000)
    @Searchable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column
    public String getVppPluginName() {
        return this.vppPluginName;
    }

    public void setVppPluginName(String vppPluginName) {
        this.vppPluginName = vppPluginName;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public Type getType() {
        return this.viewerType;
    }

    public void setType(Type type) {
        this.viewerType = type;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public Level getViewerLevel() {
        return this.viewerLevel;
    }

    public void setViewerLevel(Level level) {
        this.viewerLevel = level;
        this.viewerLevelStr = level.name();
    }

    @Transient
    public String getViewerLevelStr() {
        return this.viewerLevelStr == null ? null : this.viewerLevelStr.toLowerCase();
    }

    public void setViewerLevelStr(String level) {
        this.viewerLevelStr = level;
        this.viewerLevel = Level.valueOf(level.toUpperCase());
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column
    public String getUrl() {
        return this.url;
    }

    @Column(name="index_xml", length=4000)
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public static enum Level {
        IE,
        FILE;

    }

    public static enum Type {
        BUNDLED,
        CUSTOM;

    }
}

