/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.ws;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.ws.RestrictedIPChecker;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class WSRestrictedIpAccess
extends AbstractPhaseInterceptor<Message> {
    private static final ExLogger log = ExLogger.getExLogger(WSRestrictedIpAccess.class);

    public WSRestrictedIpAccess() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        String remoteIp = this.getRemoteIp(message);
        String serviceName = message.getExchange().getService().getName().getLocalPart();
        if (!RestrictedIPChecker.getInstance().checkAccess(remoteIp, serviceName).booleanValue()) {
            throw new SecurityException(serviceName + "Did Not Granted Authorization To Ip: " + remoteIp);
        }
        log.debug((Object)(serviceName + "Granted Authorization To Ip: " + remoteIp), new String[0]);
    }

    private String getRemoteIp(Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        try {
            InetAddress add = InetAddress.getByName(request.getRemoteAddr());
            if (add instanceof Inet6Address) {
                return null;
            }
            return request.getRemoteAddr();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

