/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.formatting;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.common.formatting.xmlbeans.MapAttribute;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class TemplateXMLFormatConverter {
    private static ExLogger logger = ExLogger.getExLogger(TemplateXMLFormatConverter.class);
    private Document m_document = null;
    private Document m_document_template = null;
    private Element m_record = null;
    private Element m_record_template = null;
    private List nsList;

    public TemplateXMLFormatConverter(String template_file) {
        this.createNew(template_file);
    }

    private void createNew(String template_file) {
        try {
            SAXBuilder builder = new SAXBuilder();
            this.m_document_template = builder.build(new File(template_file));
        }
        catch (Exception e) {
            logger.error("Unable to read template file - " + template_file, new String[0]);
        }
        this.m_record_template = this.m_document_template.getRootElement();
        this.nsList = this.m_record_template.getAdditionalNamespaces();
        Element root = new Element(this.m_document_template.getRootElement().getName());
        this.m_document = new Document(root);
        this.m_record = this.m_document.getRootElement();
        for (Namespace ns : this.nsList) {
            this.m_record.addNamespaceDeclaration(ns);
        }
    }

    public void addElement(String key, String value) {
        this.addElement(key, null, null, null, null, value);
    }

    public void addElement(String key, String xsiType, List attrlist, String nodename, String groupname, String value) {
        Element child;
        NSElement ncElem = null;
        if (nodename != null && nodename.length() > 0) {
            ncElem = this.getNamespaceElement(nodename);
            if (ncElem == null) {
                return;
            }
            child = this.m_record_template.getChild(ncElem.tagname, ncElem.namespace);
            if (child != null) {
                this.m_record.addContent((Content)((Element)child.clone()));
            }
        }
        child = null;
        if (groupname != null && groupname.length() > 0) {
            ncElem = this.getNamespaceElement(groupname);
            if (ncElem == null) {
                return;
            }
            child = TemplateXMLFormatConverter.getChildren(ncElem.tagname, this.m_document.getRootElement(), 0);
        }
        if ((ncElem = this.getNamespaceElement(key)) == null) {
            return;
        }
        Element elem = new Element(ncElem.tagname);
        elem.addContent(value);
        elem.setNamespace(ncElem.namespace);
        if (xsiType != null) {
            elem.setAttribute("type", xsiType, this.getNamespace("xsi"));
        }
        if (attrlist != null) {
            for (MapAttribute attribute : attrlist) {
                elem.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        if (child == null) {
            this.m_record.getChildren().add(elem);
        } else {
            child.addContent((Content)elem);
        }
    }

    public Namespace getNamespace(String prefix) {
        Namespace ns1 = null;
        Iterator iterator = this.nsList.iterator();
        while (iterator.hasNext() && !(ns1 = (Namespace)iterator.next()).getPrefix().equalsIgnoreCase(prefix)) {
        }
        return ns1;
    }

    public NSElement getNamespaceElement(String key) {
        String str;
        Namespace ns;
        NSElement ncElem = null;
        int colonIdx = key.indexOf(58);
        if (colonIdx != -1 && (ns = this.getNamespace(str = key.substring(0, colonIdx))) != null) {
            ncElem = new NSElement();
            ncElem.namespace = ns;
            ncElem.tagname = key.substring(colonIdx + 1);
        }
        if (ncElem == null) {
            logger.warn((Object)("No Namespace or unknown - " + key), new String[0]);
        }
        return ncElem;
    }

    public static Element getChildren(String groupname, Element current, int depth) {
        Element child = null;
        List children = current.getChildren();
        for (Element nextChild : children) {
            if (nextChild.getName().equals(groupname)) {
                child = nextChild;
                break;
            }
            child = TemplateXMLFormatConverter.getChildren(groupname, nextChild, depth + 1);
        }
        return child;
    }

    public String toXml() throws IOException {
        StringWriter sw = new StringWriter();
        XMLOutputter out = new XMLOutputter();
        out.output(this.m_document, (Writer)sw);
        sw.flush();
        sw.close();
        return sw.getBuffer().toString();
    }

    private class NSElement {
        public Namespace namespace;
        public String tagname;

        private NSElement() {
        }
    }
}

