/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.formatting;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.normalizers.Normalizer;
import com.exlibris.core.infra.common.xml.XMLNormalizer;
import com.exlibris.core.sdk.formatting.MDRecordUtil;
import com.exlibris.core.sdk.formatting.MarcHandler;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.digitool.common.formatting.TemplateXMLFormatConverter;
import com.exlibris.digitool.common.formatting.xmlbeans.MapField;
import com.exlibris.digitool.common.formatting.xmlbeans.MapNormalizer;
import com.exlibris.digitool.common.formatting.xmlbeans.MapNormalizingProfile;
import com.exlibris.digitool.common.formatting.xmlbeans.XmetadissMappingDocument;
import com.exlibris.digitool.repository.api.xmlbeans.Md;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Document;
import org.dom4j.Node;

public class XMetaDissFormatter {
    private static final String MAPPING_FILE = "xmetadiss_mapping.xml";
    private static final String TEMPLATE_FILE = "xmetadiss_template.xml";
    private static final String GENERIC_NORMALIZING_PROFILE = "generic";
    private static ExLogger logger = ExLogger.getExLogger(XMetaDissFormatter.class);
    private static XMetaDissFormatter serverFormatter = null;
    private XmetadissMappingDocument schema = null;
    private HashMap normalizingProfiles = null;
    private boolean hasValues = false;

    public XMetaDissFormatter(String schemaPath) {
        try {
            this.schema = XmetadissMappingDocument.Factory.parse(new File(schemaPath));
        }
        catch (XmlException e) {
            logger.info(DescriptorConstants.IN_UnableToParseSchema, (Object)schemaPath, e.getCause(), ((Object)((Object)e)).getClass());
        }
        catch (IOException e) {
            logger.info(DescriptorConstants.IN_UnableToParseSchema, (Object)schemaPath, e.getCause(), e.getClass());
        }
        this.init();
    }

    public XMetaDissFormatter(XmetadissMappingDocument schema) {
        this.schema = schema;
        this.init();
    }

    private void init() {
        this.loadNormalizingSettings();
    }

    public static XMetaDissFormatter getServerFormatter() {
        if (serverFormatter != null) {
            return serverFormatter;
        }
        serverFormatter = new XMetaDissFormatter(XMetaDissFormatter.loadMappingSchema());
        return serverFormatter;
    }

    public static void reset() {
        serverFormatter = null;
    }

    private void formatField(Md md, MapField field, List attributeList, String path, TemplateXMLFormatConverter dc, Hashtable mdsUnParsableList, Hashtable mdsParsedList) {
        String mdKey = this.createMdKey(md);
        if (mdsUnParsableList.get(mdKey) != null) {
            return;
        }
        Object mdDoc = mdsParsedList.get(mdKey);
        if (mdDoc == null) {
            mdDoc = MDRecordUtil.getMDRecordObject(md);
        }
        if (mdDoc == null) {
            mdsUnParsableList.put(mdKey, "");
            return;
        }
        mdsParsedList.put(mdKey, mdDoc);
        Vector v = null;
        v = mdDoc instanceof MarcHandler ? this.getMarcValuesFromPath((MarcHandler)mdDoc, path) : this.getXPathValues(mdDoc, path);
        for (int i = 0; i < v.size(); ++i) {
            String val = (String)v.elementAt(i);
            if (val == null) continue;
            val = XMLNormalizer.normalize(val);
            this.addFormattedNode(field.getTagName(), field.getXsiType(), attributeList, field.getNodeName(), field.getGroupName(), this.getNormalizedValue(val, field.getNormalizingProfilesRef()), dc);
            this.hasValues = true;
        }
    }

    private String createMdKey(Md md) {
        StringBuffer sb = new StringBuffer();
        if (md.getName() != null) {
            sb.append(md.getName());
        }
        if (md.getType() != null) {
            sb.append(":").append(md.getType());
        }
        if (md.getMid() != null) {
            sb.append(":").append(md.getMid());
        }
        return sb.toString();
    }

    public Vector getXPathValues(Object mdDoc, String xPath) {
        Vector<String> v = new Vector<String>();
        try {
            List nodes = ((Document)mdDoc).selectNodes(xPath);
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                String val = ((Node)iter.next()).getText();
                v.add(val);
            }
            return v;
        }
        catch (ClassCastException e) {
            logger.error("Skipping, Got ClassCastException mdDoc=" + mdDoc.getClass().getName() + " xpath=" + xPath, new String[0]);
            return v;
        }
    }

    private String getXmlObjectValueFromPath(Object invokeTarget, String path, String normalizingGroup) {
        if (invokeTarget == null) {
            return null;
        }
        XmlObject[] objects = ((XmlObject)invokeTarget).selectPath(path);
        if (objects == null || objects.length == 0) {
            return null;
        }
        XmlCursor cur = objects[0].newCursor();
        String value = StringUtils.replaceTags(cur.xmlText(), "");
        return this.getNormalizedValue(value, normalizingGroup);
    }

    private Vector getMarcValuesFromPath(MarcHandler mh, String path) {
        try {
            return mh.getValues(path);
        }
        catch (Exception e) {
            logger.info(DescriptorConstants.IN_UnableToGetValue, (Object)path, e.getCause(), e.getClass());
            return null;
        }
    }

    private void addFormattedNode(String tagName, String xsiType, List attributeList, String nodeName, String groupName, String value, TemplateXMLFormatConverter dc) {
        if (value != null) {
            dc.addElement(tagName, xsiType, attributeList, nodeName, groupName, value);
        }
    }

    private void loadNormalizingSettings() {
        List<Object> normalizingProfilesList = new ArrayList();
        if (this.schema.getXmetadissMapping().getNormalizingProfiles() != null) {
            MapNormalizingProfile[] normalizingProfilesArr = this.schema.getXmetadissMapping().getNormalizingProfiles().getNormalizingProfileArray();
            normalizingProfilesList = Arrays.asList(normalizingProfilesArr);
        }
        this.normalizingProfiles = new HashMap();
        if (normalizingProfilesList != null && !normalizingProfilesList.isEmpty()) {
            for (MapNormalizingProfile mapNormalizingProfile : normalizingProfilesList) {
                Iterator<MapNormalizer> normalizersIter = Arrays.asList(mapNormalizingProfile.getNormalizerArray()).iterator();
                ArrayList<String> normalizerClasses = new ArrayList<String>();
                while (normalizersIter.hasNext()) {
                    MapNormalizer normalizer = normalizersIter.next();
                    normalizerClasses.add(normalizer.getClassName());
                }
                this.normalizingProfiles.put(mapNormalizingProfile.getName(), normalizerClasses);
            }
        }
    }

    public String getNormalizedValue(String value, String normalizingProfileName) {
        if (this.normalizingProfiles == null || this.normalizingProfiles.isEmpty()) {
            return value;
        }
        try {
            Iterator normalizersIter = ((List)this.normalizingProfiles.get(normalizingProfileName)).iterator();
            while (normalizersIter.hasNext()) {
                value = ((Normalizer)Class.forName((String)normalizersIter.next()).newInstance()).normalize(value);
            }
            return value;
        }
        catch (Exception e) {
            return value;
        }
    }

    public String getNormalizingProfileNameByFieldUiDefaultText(String uiDefaultText) {
        if (uiDefaultText == null) {
            return null;
        }
        if (uiDefaultText.length() == 0) {
            return GENERIC_NORMALIZING_PROFILE;
        }
        String normalizingProfileName = null;
        if (this.schema != null && this.schema.getXmetadissMapping().getFields() != null) {
            MapField[] fields = this.schema.getXmetadissMapping().getFields().getFieldArray();
            boolean isUiDefaultTextFound = false;
            if (fields != null) {
                for (int i = 0; i < fields.length && !isUiDefaultTextFound; ++i) {
                    String currUiDefaultText = fields[i].getTagName();
                    if (currUiDefaultText == null || !currUiDefaultText.equalsIgnoreCase(uiDefaultText)) continue;
                    normalizingProfileName = fields[i].getNormalizingProfilesRef();
                    isUiDefaultTextFound = true;
                }
            }
        }
        return normalizingProfileName;
    }

    private static XmetadissMappingDocument loadMappingSchema() {
        try {
            XmetadissMappingDocument ssd = null;
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(MAPPING_FILE);
            if (in == null) {
                logger.error("Mapping file not found - xmetadiss_mapping.xml", new String[0]);
                return null;
            }
            ssd = XmetadissMappingDocument.Factory.parse(in);
            return ssd;
        }
        catch (Throwable e) {
            logger.error("Failed to parse mapping schema file xmetadiss_mapping.xml: " + e.getMessage() + e.getLocalizedMessage() + e.getCause(), new String[0]);
            return null;
        }
    }

    public XmetadissMappingDocument getSchema() {
        return this.schema;
    }
}

