/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.sds;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.digitool.config.ConfigurationManager;
import com.exlibris.digitool.sds.LegacyResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class LegacyClient {
    private static final String USER_NAME = "user_name";
    private static final String PASSWORD = "user_password";
    private static boolean m_initSuperSession = false;
    private static String m_SuperSessionHandle = "init";
    private static String m_host = null;
    private static String m_defaultLib = null;
    private String m_user = null;
    private String m_password = null;
    private String m_url = null;

    public void init() {
        this.init(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSuperSession() throws MalformedURLException, IOException, InfraException {
        String string = m_SuperSessionHandle;
        synchronized (string) {
            this.m_url = "";
            m_initSuperSession = !m_initSuperSession;
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            m_host = gpm.getParameter("sds", "url");
            if (m_host != null && !m_host.endsWith("?")) {
                m_host = m_host + "?";
            }
            m_defaultLib = gpm.getParameter("sds", "library");
            this.init(gpm.getParameter("sds", USER_NAME), gpm.getParameter("sds", PASSWORD));
            this.setOperation("login");
            LegacyResult lr = this.connectToLegacy();
            if (lr.getError() != "") {
                return;
            }
            m_SuperSessionHandle = lr.getSessionId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSuperSessionInit() {
        String string = m_SuperSessionHandle;
        synchronized (string) {
            if (m_SuperSessionHandle == null) {
                m_initSuperSession = false;
            }
        }
        return m_initSuperSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSuperSessionState(boolean p0) {
        String string = m_SuperSessionHandle;
        synchronized (string) {
            m_initSuperSession = p0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSuperSessionHandle() {
        String string = m_SuperSessionHandle;
        synchronized (string) {
            return m_SuperSessionHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSuperSessionHandle(String sess) {
        String string = m_SuperSessionHandle;
        synchronized (string) {
            m_SuperSessionHandle = sess;
        }
    }

    public void init(String user, String pass) {
        this.init(user, pass, m_SuperSessionHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String user, String pass, String handle) {
        StringBuffer urlBuff = new StringBuffer(m_host);
        String string = m_SuperSessionHandle;
        synchronized (string) {
            if (handle != null) {
                urlBuff.append("session").append("=").append(m_SuperSessionHandle);
                urlBuff.append("&").append("library").append("=").append(m_defaultLib);
            } else {
                urlBuff.append("library").append("=").append(m_defaultLib);
            }
        }
        if (user != null) {
            this.m_user = user;
            urlBuff.append("&").append(USER_NAME).append("=").append(this.m_user);
        }
        if (pass != null) {
            this.m_password = pass;
            urlBuff.append("&").append(PASSWORD).append("=").append(this.m_password);
        }
        this.m_url = urlBuff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetURL() {
        String string = m_SuperSessionHandle;
        synchronized (string) {
            this.m_url = m_initSuperSession ? new StringBuffer(m_host).append("session").append("=").append(m_SuperSessionHandle).toString() : m_host;
        }
    }

    public void setStaffPassword(String sPass) {
        this.set("staff_pwd", sPass);
    }

    public void setLibrary(String lib) {
        this.set("library", lib);
    }

    public void setPassword(String pass) {
        this.set(PASSWORD, pass);
    }

    public void setUserName(String name) {
        this.set(USER_NAME, name);
    }

    public void setStaffName(String name) {
        this.set("staff_name", name);
    }

    public void setOperation(String operation) {
        this.set("op", operation);
    }

    public void setFunction(String func) {
        this.set("func", func);
    }

    public void setFuncLibrary(String funcLib) {
        this.set("func_lib", funcLib);
    }

    public void setSubFunc(String subFunc) {
        this.set("sub_func", subFunc);
    }

    public void setType(String type) {
        this.set("type", type);
    }

    public void setStartName(String sName) {
        this.set("start_name", sName);
    }

    public void setEndName(String eName) {
        this.set("end_name", eName);
    }

    public void setHandle(String sess) {
        this.set("session", sess);
    }

    public void setBinID(String id) {
        this.set("bin_id", id);
    }

    public void setId(String id) {
        this.set("id", id);
    }

    public void setUnit(String unit) {
        this.set("unit", unit);
    }

    public void setBinSequence(String sequence) {
        this.set("bin_sequence", sequence);
    }

    public void setLanguage(String locale) {
        String language = ConfigurationManager.getInstance().getLanguage(locale);
        if (language != null) {
            this.set("con_lng", language);
        }
    }

    private void set(String key, String value) {
        StringBuffer urlBuff = null;
        int opIndex = this.m_url.indexOf(key + "=");
        if (opIndex != -1) {
            urlBuff = new StringBuffer(this.m_url.substring(0, opIndex + key.length() + 1));
            String ending = this.m_url.substring(opIndex);
            int endOfOp = ending.indexOf("&");
            this.m_url = endOfOp != -1 ? urlBuff.append(value).append(ending.substring(endOfOp)).toString() : urlBuff.append(value).toString();
        } else {
            this.m_url = new StringBuffer(this.m_url).append("&").append(key).append("=").append(value).toString();
        }
    }

    public LegacyResult connectToLegacy() throws MalformedURLException, IOException {
        String line;
        URL url = new URL(this.m_url);
        URLConnection conn = url.openConnection();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        StringBuffer content = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            content.append(line);
        }
        rd.close();
        return new LegacyResult(content.toString());
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getUrl() {
        return this.m_url;
    }
}

