/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.index;

import com.exlibris.core.infra.api.xmlbeans.Field;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.normalizers.NormalizerUtil;
import com.exlibris.core.infra.common.util.ReflectionUtil;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.common.xml.XMLNormalizer;
import com.exlibris.core.repository.index.CoreMetadataIndexer;
import com.exlibris.core.sdk.formatting.FormattedDocument;
import com.exlibris.core.sdk.formatting.MDRecordUtil;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxDocumentFactory;
import com.exlibris.digitool.common.dnx.DnxDocumentHelper;
import com.exlibris.digitool.repository.api.xmlbeans.Md;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import org.dom4j.Document;

public class MetadataIndexer
extends CoreMetadataIndexer {
    private static ExLogger logger = ExLogger.getExLogger(MetadataIndexer.class);

    @Override
    protected void formatField(Md md, Field field, String path, FormattedDocument fd, Hashtable<String, String> mdsUnParsableList, Hashtable<String, Object> mdsParsedList, String prefix) {
        String mdKey = this.createMdKey(md);
        if (mdsUnParsableList.get(mdKey) != null) {
            return;
        }
        Object mdDoc = mdsParsedList.get(mdKey);
        if (mdDoc == null) {
            mdDoc = MDRecordUtil.getMDRecordObject(md);
        }
        if (mdDoc == null) {
            mdsUnParsableList.put(mdKey, "");
            return;
        }
        mdsParsedList.put(mdKey, mdDoc);
        String type = md.getType();
        Vector<String> v = type.equalsIgnoreCase("dnx") ? this.getDnxValuesFromPath(mdDoc, path, type) : ReflectionUtil.getXPathValues(mdDoc, path);
        for (int i = 0; i < v.size(); ++i) {
            String val = v.elementAt(i);
            if (val == null) continue;
            val = XMLNormalizer.normalize(val);
            String indexCode = field.getIndexCode();
            String profileName = field.getNormalizingProfilesRef();
            String normalizedValue = NormalizerUtil.normalizeWithProfileName(profileName, val);
            if (indexCode == null || normalizedValue == null) continue;
            if (!StringUtils.isEmptyString(prefix)) {
                indexCode = prefix + "_" + indexCode;
            }
            fd.createElement(indexCode, normalizedValue);
        }
    }

    private Vector<String> getDnxValuesFromPath(Object mdDoc, String path, String type) {
        String[] splitPath;
        Vector<String> v = new Vector<String>();
        DnxDocumentHelper dnxDocumentHelper = null;
        DnxDocumentHelper object = null;
        try {
            DnxDocument dnxDocument = DnxDocumentFactory.getInstance().parse(((Document)mdDoc).asXML());
            if (type.equalsIgnoreCase("dnx")) {
                object = dnxDocumentHelper = new DnxDocumentHelper(dnxDocument);
            }
        }
        catch (Exception e) {
            logger.error("Skipping, Got Exception while parsing Dnx Metadata for mdDoc=" + mdDoc.getClass().getName() + " xpath=" + path, new String[0]);
            return v;
        }
        for (String aPath : splitPath = path.split("\\|")) {
            String value;
            try {
                value = ReflectionUtil.property2value((Object)object, aPath);
            }
            catch (IntrospectionException e) {
                logger.error("Skipping, Got Exception while parsing Dnx Metadata for mdDoc=" + mdDoc.getClass().getName() + " xpath=" + path, new String[0]);
                return v;
            }
            catch (IllegalAccessException e) {
                logger.error("Skipping, Got Exception while parsing Dnx Metadata for mdDoc=" + mdDoc.getClass().getName() + " xpath=" + path, new String[0]);
                return v;
            }
            catch (InvocationTargetException e) {
                logger.error("Skipping, Got Exception while parsing Dnx Metadata for mdDoc=" + mdDoc.getClass().getName() + " xpath=" + path, new String[0]);
                return v;
            }
            v.add(value);
        }
        return v;
    }
}

