/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import net.byteseek.io.reader.WindowReader;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;

public class SevenZipReader
implements SeekableByteChannel {
    private final WindowReader reader;
    private long position;
    private boolean isOpen = true;

    public SevenZipReader(WindowReader reader) {
        this.reader = reader;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.isOpen) {
            int bytesCopied = ArchiveFileUtils.copyToBuffer(this.reader, this.position, dst);
            this.position += (long)bytesCopied;
            return bytesCopied;
        }
        return -1;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.reader.length();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.reader + ")";
    }
}

