/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.edidoc;

import at.gv.e_government.reference.namespace.edidoc._20130808_.EdiaktType;
import bsh.EvalError;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementCantAddException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.LevelOfDescriptionSet;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.mapping.edidoc.ExportException;
import ch.docuteam.mapping.edidoc.ExportType;
import ch.docuteam.mapping.edidoc.FieldType;
import ch.docuteam.mapping.edidoc.IncompatibleMappingAndLevelsException;
import ch.docuteam.mapping.edidoc.InvalidMappingException;
import ch.docuteam.mapping.edidoc.InvalidSIPException;
import ch.docuteam.mapping.edidoc.LevelType;
import ch.docuteam.mapping.edidoc.LevelsNotFoundException;
import ch.docuteam.mapping.edidoc.MappingAdapter;
import ch.docuteam.mapping.edidoc.MatterhornFieldType;
import ch.docuteam.mapping.edidoc.RequiredPropertyNotFoundException;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.Zipper;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import com.fabasoft.editions.schemas.disposal.export.ArchiveExportType;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SIPExporter {
    private static final String TMP_DIR_PREFIX = "edidoc";
    private static final String HEADER_FOLDER = ".";
    private static final String CONTENT_XML_FILE_NAME = "content.xml";
    static final String INCLUDE_CONTENT_XML = "file";
    private Path tempFolderPath;
    private Path sourceSIPPath;
    private Document metsDocument;
    private LevelOfDescriptionSet metsLevels;
    private final String operatorName;
    private final MappingAdapter mappingAdapter;

    public SIPExporter(String operatorName, MappingAdapter mappingAdapter, String levelsConfigPath) {
        this.operatorName = operatorName;
        this.mappingAdapter = mappingAdapter;
        if (!LevelOfDescription.isInitializationFileFound((String)levelsConfigPath)) {
            throw new LevelsNotFoundException(levelsConfigPath);
        }
        LevelOfDescription.setInitializationFilePath((String)levelsConfigPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path exportEdidocToMETS(Path edidocSipPath, Path targetPath, Path steuerXmlPath) throws IOException {
        ArchiveExportType steuerXml = null;
        if (this.mappingAdapter.isUseSteuerXml() && steuerXmlPath != null) {
            steuerXml = SIPExporter.unmarshalXml(steuerXmlPath, ArchiveExportType.class);
            this.validateMd5OfPackage(steuerXml.getMd5Hash(), edidocSipPath);
        }
        this.tempFolderPath = Files.createTempDirectory(Paths.get(FileUtil.getTempFolder(), new String[0]), TMP_DIR_PREFIX, new FileAttribute[0]);
        this.sourceSIPPath = this.unzip(edidocSipPath, this.tempFolderPath);
        String sipNameWithoutExtension = FileUtil.asFileNameWithoutExtension((File)edidocSipPath.toFile());
        try {
            EdiaktType ediaktSIP = SIPExporter.unmarshalXml(this.sourceSIPPath.resolve(CONTENT_XML_FILE_NAME), EdiaktType.class);
            Path path = this.generateMetsSIP(ediaktSIP, steuerXml, this.sourceSIPPath, sipNameWithoutExtension, targetPath);
            return path;
        }
        finally {
            this.cleanUp();
        }
    }

    private void validateMd5OfPackage(String md5FromSteuerXml, Path edidocSipPath) {
        try {
            String calculatedMd5Hash = DigestUtils.md5Hex((InputStream)new FileInputStream(edidocSipPath.toFile()));
            if (!calculatedMd5Hash.equals(md5FromSteuerXml)) {
                throw new InvalidSIPException("Calculated md5 does not match md5 of Steuer-XML");
            }
        }
        catch (IOException e) {
            throw new ExportException("File cloud not be read", e);
        }
    }

    private Path generateMetsSIP(EdiaktType packageSIP, ArchiveExportType steuerXml, Path edidocSipPath, String sipNameWithoutExtension, Path targetPath) {
        try {
            Path metsSIPPath;
            Object sipName = sipNameWithoutExtension;
            if (!this.mappingAdapter.isOutputSIPUnzipped()) {
                sipName = (String)sipName + ".zip";
            }
            if ((metsSIPPath = targetPath.resolve((String)sipName)).toFile().exists()) {
                throw new FileAlreadyExistsException((String)sipName, metsSIPPath.getParent().toString());
            }
            Logger.debug((Object)("metsSIPPath: " + metsSIPPath));
            this.metsDocument = Document.createNewWithRootFolderName((String)metsSIPPath.toString(), (String)sipNameWithoutExtension, (String)this.mappingAdapter.getSaId(), (String)this.mappingAdapter.getDssId(), (String)this.operatorName);
            NodeAbstract targetRootNode = this.metsDocument.getStructureMap().getRoot();
            this.metsLevels = this.metsDocument.getLevels();
            this.validateMappingAgainstMetsLevels(this.metsLevels, this.mappingAdapter);
            NodeFolder rootFolder = (NodeFolder)targetRootNode;
            if (this.mappingAdapter.isUseSteuerXml()) {
                targetRootNode.getMyDigiprov().addNewEvent("Fixity Check", String.format("Checksum of package control xml: %s", steuerXml.getMd5Hash()), "Success", "");
            }
            this.exportRecursively(packageSIP, rootFolder);
            if (steuerXml != null) {
                this.exportRecursively(steuerXml, rootFolder);
            }
            this.exportMetadataFile(edidocSipPath, rootFolder);
            this.metsDocument.saveWithoutBackup();
            this.metsDocument.cleanupWorkingCopy();
            Path path = metsSIPPath;
            return path;
        }
        catch (Exception ex) {
            this.cleanupAtExceptionHandling();
            throw new ExportException("generateMetsSIP failed", ex);
        }
        finally {
            if (this.metsDocument != null) {
                this.metsDocument.unlockIfNecessary();
            }
        }
    }

    private void cleanupAtExceptionHandling() {
        if (this.metsDocument != null) {
            try {
                this.metsDocument.cleanupWorkingCopy();
            }
            catch (FileUtilExceptionListException | IOException e1) {
                Logger.warn((Object)"Could not cleanup working copy", (Throwable)e1);
            }
            try {
                FileUtils.deleteDirectory((File)new File(this.metsDocument.getFilePath()).getParentFile());
            }
            catch (IOException e2) {
                Logger.warn((Object)"SIP deletion unsuccessful", (Throwable)e2);
            }
        }
    }

    void validateMappingAgainstMetsLevels(LevelOfDescriptionSet metsLevels_, MappingAdapter mappingAdapter_) {
        List mappedLevels;
        List allMetsLevels = metsLevels_.getAll().stream().map(LevelOfDescription::getName).collect(Collectors.toList());
        if (!allMetsLevels.containsAll(mappedLevels = mappingAdapter_.getMappedLevels().values().stream().map(LevelType::getMatterhorn).filter(level -> !level.equals("Undefiniert")).collect(Collectors.toList()))) {
            Logger.error((Object)"mapping and levels are not compatible");
            Logger.debug((Object)("METS levels: " + StringUtils.join(allMetsLevels, (String)", ")));
            Logger.debug((Object)("mapped levels: " + StringUtils.join(mappedLevels, (String)", ")));
            throw new IncompatibleMappingAndLevelsException("mapping and levels are not compatible: mappedLevels should be a subset of allMetsLevels");
        }
    }

    private void exportMetadataFile(Path edidocSipPath, NodeFolder parentNode) {
        if (this.mappingAdapter.getContentXML().getInclude().contains(INCLUDE_CONTENT_XML)) {
            Path metadataPath = edidocSipPath.resolve(HEADER_FOLDER).resolve(CONTENT_XML_FILE_NAME);
            try {
                String configuredLevel;
                NodeAbstract fileNode = parentNode.insertFileOrFolder(metadataPath.toString(), true);
                if (this.mappingAdapter.getContentXML().getTitle() != null) {
                    fileNode.setUnitTitle(this.mappingAdapter.getContentXML().getTitle());
                }
                if ((configuredLevel = this.mappingAdapter.getContentXML().getLevel()) != null) {
                    fileNode.setLevel(this.metsLevels.get(configuredLevel));
                } else {
                    fileNode.setLevel(this.metsLevels.getUndefined());
                }
            }
            catch (FileAlreadyExistsException | FileOperationNotAllowedException | FolderNameIsEmptyException | FileUtilExceptionListException | IOException | IllegalAccessException | InvocationTargetException e) {
                throw new ExportException("Could not add metadata file to folder", e);
            }
        }
    }

    private void exportRecursively(Object objectToExport, NodeFolder targetFolder) {
        String classNameForObject = this.getClassNameForObject(objectToExport);
        LevelType levelType = this.mappingAdapter.getMappedLevels().get(classNameForObject);
        if (levelType == null) {
            throw new InvalidMappingException("Could not find mapping for class: " + classNameForObject);
        }
        if (levelType.isCreatesNewFolder()) {
            try {
                targetFolder = targetFolder.createNewFolder(this.getProperty(objectToExport, levelType.getFolderNameProperty()), true);
                targetFolder.setLevel(this.metsLevels.get(levelType.getMatterhorn()));
            }
            catch (FileAlreadyExistsException | FileOperationNotAllowedException | FolderNameIsEmptyException | FileUtilExceptionListException | IOException | IllegalAccessException | InvocationTargetException e) {
                throw new ExportException("Could not create new folder", e);
            }
        }
        NodeFolder finalTargetFolder = targetFolder;
        levelType.getField().forEach(field -> this.exportRecursively(objectToExport, (FieldType)field, finalTargetFolder));
    }

    private String getClassNameForObject(Object objectToExport) {
        ArrayList<String> names = new ArrayList<String>();
        Class<?> objClass = objectToExport.getClass();
        names.add(0, objClass.getSimpleName());
        do {
            if ((objClass = objClass.getEnclosingClass()) == null) continue;
            names.add(0, objClass.getSimpleName());
        } while (objClass != null);
        return String.join((CharSequence)HEADER_FOLDER, names);
    }

    private String getProperty(Object object, String propertyAccessor) {
        Object traversedObject = object;
        for (String propName : propertyAccessor.split("\\.")) {
            Optional<Object> prop = this.getValueForField(traversedObject, propName);
            if (!prop.isPresent()) {
                throw new RequiredPropertyNotFoundException("Property '" + propName + "' was not found on object '" + this.getClassNameForObject(traversedObject) + "'");
            }
            traversedObject = prop.get();
        }
        return traversedObject.toString();
    }

    private void exportRecursively(Object objectToExport, FieldType field, NodeFolder targetFolder) {
        Optional<Object> valueForField = this.getValueForField(objectToExport, field.getEdidoc());
        if (valueForField.isPresent()) {
            Object val = valueForField.get();
            switch (field.getType()) {
                case METADATA: {
                    this.exportMetadata(val, targetFolder, field);
                    break;
                }
                case PREMIS: {
                    this.exportPremis(val, targetFolder);
                    break;
                }
                case FIELD_NAME_BOOLEAN: {
                    this.exportFieldNameBoolean(val, targetFolder, field);
                    break;
                }
                case CDATA: {
                    this.exportCdata(val, targetFolder, field);
                    break;
                }
                case COMPLEX: {
                    if (val instanceof List) {
                        ((List)val).forEach(obj -> this.exportRecursively(obj, targetFolder));
                        break;
                    }
                    this.exportRecursively(val, targetFolder);
                    break;
                }
                case KEY_VALUE: {
                    if (val instanceof List) {
                        ((List)val).forEach(obj -> this.exportKeyValue(obj, targetFolder));
                        break;
                    }
                    this.exportKeyValue(val, targetFolder);
                    break;
                }
                case FILE: {
                    this.exportFile(val, targetFolder);
                    break;
                }
                default: {
                    throw new InvalidMappingException("Undefined mapping property: " + field.getType().value());
                }
            }
        } else {
            Logger.info((Object)("Failed to get value for field '" + field.getEdidoc() + "' from '" + objectToExport.getClass().getName() + "'"));
        }
    }

    private void exportKeyValue(Object obj, NodeFolder targetFolder) {
        String key = this.getValueForField(obj, "key").map(Object::toString).orElseThrow();
        String value = this.getValueForField(obj, "value").map(Object::toString).orElseThrow();
        MatterhornFieldType matterhornMapping = this.mappingAdapter.getKeyValueMap().get(key);
        if (matterhornMapping != null) {
            FieldType fieldType = new FieldType();
            fieldType.setEdidoc(key);
            fieldType.setMatterhorn(matterhornMapping);
            fieldType.setType(ExportType.KEY_VALUE);
            this.exportMetadata(value, targetFolder, fieldType);
        }
    }

    private void exportFile(Object objectToExport, NodeFolder targetFolder) {
        if (objectToExport instanceof List) {
            ((List)objectToExport).forEach(obj -> this.exportFile(obj, targetFolder));
        }
        String classNameForObject = this.getClassNameForObject(objectToExport);
        LevelType levelType = this.mappingAdapter.getMappedLevels().get(classNameForObject);
        if (this.missingRequiredProperties(levelType, MatterhornFieldType.FILE_NAME, MatterhornFieldType.FILE_URL)) {
            throw new InvalidMappingException(String.format("Mapping of: '%s' does not contain all file properties", classNameForObject));
        }
        Map<MatterhornFieldType, String> fieldToFilesMap = this.extractFileMap(objectToExport, levelType);
        String fileUrl = fieldToFilesMap.get((Object)MatterhornFieldType.FILE_URL);
        try {
            Path path = this.sourceSIPPath.resolve(fileUrl);
            NodeFile fileNode = (NodeFile)targetFolder.insertFileOrFolder(path.toString(), true);
            fileNode.setLevel(this.metsLevels.get(levelType.getMatterhorn()));
        }
        catch (FileAlreadyExistsException | FileOperationNotAllowedException | FolderNameIsEmptyException | FileUtilExceptionListException | IOException | IllegalAccessException | InvocationTargetException e) {
            throw new ExportException("could not create file", e);
        }
    }

    private void exportPremis(Object objectToExport, NodeFolder targetFolder) {
        if (objectToExport instanceof List) {
            ((List)objectToExport).forEach(obj -> this.exportPremis(obj, targetFolder));
        } else {
            String classNameForObject = this.getClassNameForObject(objectToExport);
            LevelType levelType = this.mappingAdapter.getMappedLevels().get(classNameForObject);
            if (this.missingRequiredProperties(levelType, MatterhornFieldType.PREMIS_EVENT_DATE_TIME, MatterhornFieldType.PREMIS_EVENT_DETAIL, MatterhornFieldType.PREMIS_EVENT_TYPE)) {
                throw new InvalidMappingException(String.format("Mapping of: '%s' does not contain all premis properties", classNameForObject));
            }
            Map<MatterhornFieldType, String> fieldToPremisMap = this.extractPremisMap(objectToExport, levelType);
            String eventDetail = fieldToPremisMap.get((Object)MatterhornFieldType.PREMIS_EVENT_DETAIL);
            String eventDateTime = fieldToPremisMap.get((Object)MatterhornFieldType.PREMIS_EVENT_DATE_TIME);
            String eventOutcomeDetail = fieldToPremisMap.get((Object)MatterhornFieldType.PREMIS_EVENT_OUTCOME_DETAIL);
            String eventType = fieldToPremisMap.get((Object)MatterhornFieldType.PREMIS_EVENT_TYPE);
            targetFolder.getMyDigiprov().addNewEvent(eventDateTime, eventType, eventDetail, "Success", eventOutcomeDetail == null ? "" : eventOutcomeDetail);
        }
    }

    private Map<MatterhornFieldType, String> extractPremisMap(Object objectToExport, LevelType levelType) {
        return levelType.getField().stream().map(field -> new ImmutablePair(field, this.getValueForField(objectToExport, field.getEdidoc()))).filter(pair -> ((Optional)pair.getValue()).isPresent()).map(pair -> new ImmutablePair((Object)((FieldType)pair.getKey()), ((Optional)pair.getValue()).get())).map(pair -> {
            if (((FieldType)pair.getKey()).getType() == ExportType.CDATA) {
                return new ImmutablePair((Object)((FieldType)pair.getKey()).getMatterhorn(), (Object)this.mapToCdata(pair.getValue()));
            }
            return new ImmutablePair((Object)((FieldType)pair.getKey()).getMatterhorn(), (Object)pair.getValue().toString());
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private Map<MatterhornFieldType, String> extractFileMap(Object objectToExport, LevelType levelType) {
        return levelType.getField().stream().map(field -> new ImmutablePair((Object)field.getMatterhorn(), this.getValueForField(objectToExport, field.getEdidoc()))).filter(pair -> ((Optional)pair.getValue()).isPresent()).map(pair -> new ImmutablePair((Object)((MatterhornFieldType)((Object)((Object)pair.getKey()))), (Object)((Optional)pair.getValue()).get().toString())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private boolean missingRequiredProperties(LevelType levelType, MatterhornFieldType ... fieldTypes) {
        return !levelType.getField().stream().map(FieldType::getMatterhorn).collect(Collectors.toList()).containsAll(Arrays.asList(fieldTypes));
    }

    private void exportCdata(Object val, NodeFolder targetFolder, FieldType field) {
        if (val instanceof List) {
            List cDataList = ((List)val).stream().map(this::mapToCdata).collect(Collectors.toList());
            this.exportMetadata(cDataList, targetFolder, field);
        } else {
            this.exportMetadata(this.mapToCdata(val), targetFolder, field);
        }
    }

    @VisibleForTesting
    String mapToCdata(Object val) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{val.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter stringWriter = new StringWriter();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            JAXBElement rootElement = new JAXBElement(new QName(val.getClass().getSimpleName().replaceAll("Type$", "")), val.getClass(), val);
            marshaller.marshal((Object)rootElement, (Writer)stringWriter);
            return String.format("<![CDATA[\n%s\n]]>", stringWriter.toString());
        }
        catch (JAXBException e) {
            throw new ExportException("Could not write element to cdata", e);
        }
    }

    private void exportFieldNameBoolean(Object isTrue, NodeFolder targetFolder, FieldType fieldType) {
        if (isTrue instanceof Boolean) {
            if (((Boolean)isTrue).booleanValue()) {
                this.exportMetadata(fieldType.getEdidoc(), targetFolder, fieldType);
            }
        } else {
            throw new InvalidMappingException(String.format("Boolean type defined although object '%s' is not Boolean", fieldType.getEdidoc()));
        }
    }

    private void exportMetadata(Object val, NodeFolder targetFolder, FieldType fieldType) {
        try {
            if (val instanceof List) {
                List list = (List)val;
                for (int i = 0; i < list.size(); ++i) {
                    targetFolder.addDynamicMetadataElementInstanceWithName(fieldType.getMatterhorn().value());
                    targetFolder.setDynamicMetadataValueForName(fieldType.getMatterhorn().value(), i, list.get(i).toString());
                }
            } else if (fieldType.getMatterhorn().equals((Object)MatterhornFieldType.UNIT_TITLE)) {
                targetFolder.setUnitTitle(val.toString());
            } else {
                int alreadyExistingCount = targetFolder.getAllDynamicMetadataValuesForName(fieldType.getMatterhorn().value()).size();
                if (alreadyExistingCount > 0) {
                    targetFolder.addDynamicMetadataElementInstanceWithName(fieldType.getMatterhorn().value());
                }
                targetFolder.setDynamicMetadataValueForName(fieldType.getMatterhorn().value(), alreadyExistingCount, val.toString());
            }
        }
        catch (EvalError | LevelMetadataElementIsReadOnly | MetadataElementAllowedValuesException | MetadataElementCantAddException | MetadataElementIsNotAllowedException | MetadataElementIsNotDefinedException | MetadataElementSetterPostActionException | MetadataElementValidatorException | IllegalAccessException | InvocationTargetException e) {
            throw new ExportException(String.format("Could not set for type: '%s', metadata: '%s' on Folder: ''%s", fieldType.getEdidoc(), val.toString(), targetFolder.toString()), e);
        }
    }

    private Optional<Object> getValueForField(Object objectContainingField, String fieldName) {
        Optional<Object> valueForField = this.getValueForField(objectContainingField, fieldName, "get");
        if (valueForField.isPresent()) {
            return valueForField;
        }
        return this.getValueForField(objectContainingField, fieldName, "is");
    }

    private Optional<Object> getValueForField(Object objectContainingField, String fieldName, String methodPrefix) {
        String methodName = methodPrefix + StringUtils.capitalize((String)fieldName);
        try {
            Method method = objectContainingField.getClass().getMethod(methodName, new Class[0]);
            return Optional.ofNullable(method.invoke(objectContainingField, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            Logger.debug((Object)("Failed to get value for field '" + fieldName + "' with accessor " + methodName + " from '" + objectContainingField.getClass().getName() + "'"), (Throwable)ex);
            return Optional.empty();
        }
    }

    @VisibleForTesting
    static <T> T unmarshalXml(Path pathToFile, Class<T> targetClass) {
        try {
            XMLStreamReader metadataFile = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(pathToFile.toFile()));
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement jaxbElement = jaxbUnmarshaller.unmarshal(metadataFile, targetClass);
            return (T)jaxbElement.getValue();
        }
        catch (FileNotFoundException | JAXBException | XMLStreamException e) {
            throw new InvalidSIPException(String.format("Cannot unmarshal metadataFile '%s'", pathToFile), e);
        }
    }

    public void cleanUp() {
        this.cleanupTempFile(this.sourceSIPPath);
        this.cleanupTempFile(this.tempFolderPath);
    }

    private void cleanupTempFile(Path tempFilePath) {
        if (tempFilePath != null && tempFilePath.toFile().exists()) {
            try {
                FileUtils.deleteDirectory((File)tempFilePath.toFile());
            }
            catch (IOException e) {
                Logger.error((Object)("cannot cleanup temporary file: " + tempFilePath));
            }
        }
    }

    @VisibleForTesting
    Path unzip(Path zipPath, Path tempFolderPath) throws IOException {
        Logger.debug((Object)("Unzipping '" + zipPath));
        Zipper.unzip((String)zipPath.toAbsolutePath().toString(), (String)tempFolderPath.toString());
        return tempFolderPath;
    }
}

