/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.signature.droid6.FFSignatureFile;
import uk.gov.nationalarchives.droid.core.signature.xml.SAXModelBuilder;

public class SignatureFileParser {
    public static final String SIGNATURE_FILE_NS = "http://www.nationalarchives.gov.uk/pronom/SignatureFile";

    public FFSignatureFile parseSigFile(Path theFileName) throws SignatureParseException {
        SAXModelBuilder mb = new SAXModelBuilder();
        XMLReader parser = this.getXMLReader(mb);
        try (BufferedReader in = Files.newBufferedReader(theFileName, StandardCharsets.UTF_8);){
            parser.parse(new InputSource(in));
        }
        catch (IOException | SAXException e) {
            throw new SignatureParseException(e.getMessage(), e);
        }
        return (FFSignatureFile)mb.getModel();
    }

    private XMLReader getXMLReader(SAXModelBuilder mb) throws SignatureParseException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SAXParser saxParser = factory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            mb.setupNamespace(SIGNATURE_FILE_NS, true);
            parser.setContentHandler(mb);
            return parser;
        }
        catch (ParserConfigurationException e) {
            throw new SignatureParseException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new SignatureParseException(e.getMessage(), e);
        }
    }
}

