/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import de.waldheinz.fs.FsDirectoryEntry;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public final class ArchiveFileUtils {
    private static final String TEMP_FILENAME_PREFIX = "droid-archive~";
    private static final String SSP_DELIMITER = ":/";
    private static final String ARCHIVE_DELIMITER = "!/";
    private static final String COLON = ":";
    private static final int WRITE_BUFFER_CAPACITY = 8192;
    private static final int FS_READ_BYTE_BUFFER_SIZE = 0x100000;

    private ArchiveFileUtils() {
    }

    public static URI toZipUri(URI parent, String zipEntry) {
        return ArchiveFileUtils.toUri(parent, zipEntry, ImageType.ZIP);
    }

    public static URI toIsoImageUri(URI parent, String imageEntry) {
        return ArchiveFileUtils.toUri(parent, imageEntry, ImageType.ISO);
    }

    public static URI toRarUri(URI parent, String rarEntry) {
        return ArchiveFileUtils.toUri(parent, rarEntry, ImageType.RAR);
    }

    public static URI toTarUri(URI parent, String tarEntry) {
        return ArchiveFileUtils.toUri(parent, tarEntry, ImageType.TAR);
    }

    public static URI toSevenZUri(URI parent, String sevenZipEntry) {
        return ArchiveFileUtils.toUri(parent, sevenZipEntry, ImageType.SEVENZ);
    }

    public static URI toFatImageUri(URI parent, String fatEntry) {
        return ArchiveFileUtils.toUri(parent, fatEntry, ImageType.FAT);
    }

    public static URI toWebArchiveUri(String archiveType, URI parent, String warcEntry) {
        String parentScheme = parent.getScheme();
        String parentSsp = parent.getSchemeSpecificPart();
        StringBuilder builder = new StringBuilder(parentSsp.length() + ARCHIVE_DELIMITER.length() + warcEntry.length());
        builder.append(archiveType).append(COLON).append(parentScheme);
        String newScheme = builder.toString();
        builder.setLength(0);
        builder.append(parentSsp).append(ARCHIVE_DELIMITER).append(warcEntry);
        String newSSP = builder.toString();
        try {
            return new URI(newScheme, newSSP, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Path writeEntryToTemp(Path tempDir, ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        Path path;
        block11: {
            Path tempFile = Files.createTempFile(tempDir, TEMP_FILENAME_PREFIX, null, new FileAttribute[0]);
            SeekableByteChannel out = Files.newByteChannel(tempFile, new OpenOption[0]);
            try {
                out.write(buffer);
                ByteBuffer buf = ByteBuffer.allocate(8192);
                buf.clear();
                while (channel.read(buf) >= 0 || buf.position() != 0) {
                    buf.flip();
                    out.write(buf);
                    buf.compact();
                }
                path = tempFile;
                if (out == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException ex) {
                    if (channel != null) {
                        channel.close();
                    }
                    if (tempFile != null) {
                        Files.deleteIfExists(tempFile);
                    }
                    throw ex;
                }
            }
            out.close();
        }
        return path;
    }

    public static Path writeFsFileToTemp(FsDirectoryEntry fsFile, Path tempDir) throws IOException {
        Path tempFilePath = tempDir.resolve(fsFile.getName());
        if (fsFile.isFile() && fsFile.getFile().getLength() > 0L) {
            int sourceFileOffset = 0;
            long fileLength = fsFile.getFile().getLength();
            int fileLengthMod = (int)fileLength % 0x100000;
            int blockSize = fileLengthMod == 0 ? 0x100000 : fileLengthMod;
            ByteBuffer bb = ByteBuffer.allocateDirect(blockSize);
            fsFile.getFile().read((long)sourceFileOffset, bb);
            bb.flip();
            try (FileChannel wChannel = FileChannel.open(tempFilePath, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);){
                wChannel.write(bb);
                if ((long)(sourceFileOffset += blockSize) < fileLength) {
                    ByteBuffer maxBuffer = ByteBuffer.allocateDirect(0x100000);
                    while ((long)sourceFileOffset < fileLength) {
                        fsFile.getFile().read((long)sourceFileOffset, maxBuffer);
                        maxBuffer.flip();
                        wChannel.write(maxBuffer);
                        sourceFileOffset += 0x100000;
                        maxBuffer.clear();
                    }
                }
            }
        }
        return tempFilePath;
    }

    public static Path writeEntryToTemp(Path tempDir, byte[] buffer, InputStream in) throws IOException {
        Path path;
        Path tempFile = Files.createTempFile(tempDir, TEMP_FILENAME_PREFIX, null, new FileAttribute[0]);
        BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));
        try {
            byte[] buf = new byte[8192];
            ((OutputStream)out).write(buffer);
            int bytesRead = in.read(buf);
            while (bytesRead > 0) {
                ((OutputStream)out).write(buf, 0, bytesRead);
                bytesRead = in.read(buf);
            }
            ((OutputStream)out).flush();
            path = tempFile;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RuntimeException ex) {
                if (in != null) {
                    in.close();
                }
                if (tempFile != null) {
                    Files.deleteIfExists(tempFile);
                }
                throw ex;
            }
        }
        ((OutputStream)out).close();
        return path;
    }

    public static URI toGZipUri(URI parent) {
        String parentScheme = parent.getScheme();
        String parentSsp = parent.getSchemeSpecificPart();
        String gzEntryName = GzipUtils.getUncompressedFilename((String)FilenameUtils.getName((String)parent.getSchemeSpecificPart()));
        StringBuilder builder = new StringBuilder(parentSsp.length() + ARCHIVE_DELIMITER.length() + gzEntryName.length());
        builder.append("gz:").append(parentScheme);
        String newScheme = builder.toString();
        builder.setLength(0);
        builder.append(parentSsp).append(ARCHIVE_DELIMITER).append(gzEntryName);
        String newSSP = builder.toString();
        try {
            return new URI(newScheme, newSSP, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI toBZipUri(URI parent) {
        String parentScheme = parent.getScheme();
        String parentSsp = parent.getSchemeSpecificPart();
        String gzEntryName = GzipUtils.getUncompressedFilename((String)FilenameUtils.getName((String)parent.getSchemeSpecificPart()));
        StringBuilder builder = new StringBuilder(parentSsp.length() + ARCHIVE_DELIMITER.length() + gzEntryName.length());
        builder.append("bz:").append(parentScheme);
        String newScheme = builder.toString();
        builder.setLength(0);
        builder.append(parentSsp).append(ARCHIVE_DELIMITER).append(gzEntryName);
        String newSSP = builder.toString();
        try {
            return new URI(newScheme, newSSP, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI toReplayUri(URI requestUri) {
        String originSsp = StringUtils.substringBetween((String)requestUri.toString(), (String)SSP_DELIMITER, (String)"!");
        String scheme = StringUtils.substringBefore((String)requestUri.toString(), (String)SSP_DELIMITER);
        if (originSsp != null) {
            return URI.create(StringUtils.substringAfterLast((String)scheme, (String)COLON) + SSP_DELIMITER + originSsp);
        }
        return requestUri;
    }

    public static List<String> getAncestorPaths(String path) {
        ArrayList<String> paths = new ArrayList<String>();
        if (path != null && !path.isEmpty()) {
            String processPath = path;
            int lastSeparator = processPath.length() - 1;
            while (lastSeparator >= 0) {
                String separator = path.substring(lastSeparator, lastSeparator + 1);
                processPath = processPath.substring(0, lastSeparator);
                paths.add(processPath + separator);
                lastSeparator = FilenameUtils.indexOfLastSeparator((String)processPath);
            }
        }
        return paths;
    }

    public static int copyToBuffer(WindowReader reader, long position, byte[] buffer, int offset, int length) throws IOException {
        int bytesCopied;
        int bytesToCopy;
        long pos = position;
        int bytesToRead = Math.min(length, buffer.length - offset);
        Window window = reader.getWindow(pos);
        for (bytesCopied = 0; bytesCopied < bytesToRead && window != null; bytesCopied += bytesToCopy) {
            int positionInWindow = reader.getWindowOffset(pos);
            int remainingBytes = bytesToRead - bytesCopied;
            int availableBytes = window.length() - positionInWindow;
            bytesToCopy = remainingBytes < availableBytes ? remainingBytes : availableBytes;
            System.arraycopy(window.getArray(), positionInWindow, buffer, offset + bytesCopied, bytesToCopy);
            window = reader.getWindow(pos += (long)bytesToCopy);
        }
        return bytesCopied;
    }

    public static int copyToBuffer(WindowReader reader, long position, ByteBuffer buffer) throws IOException {
        long pos = position;
        int bytesCopied = 0;
        int bufferRemaining = buffer.remaining();
        Window window = reader.getWindow(pos);
        while (bufferRemaining > 0 && window != null) {
            int positionInWindow = reader.getWindowOffset(pos);
            int availableBytes = window.length() - positionInWindow;
            int bytesToCopy = availableBytes <= bufferRemaining ? availableBytes : bufferRemaining;
            buffer.put(window.getArray(), positionInWindow, bytesToCopy);
            bytesCopied += bytesToCopy;
            bufferRemaining = buffer.remaining();
            window = reader.getWindow(pos += (long)bytesToCopy);
        }
        return bytesCopied;
    }

    private static URI toUri(URI parent, String entry, ImageType type) {
        String parentScheme = parent.getScheme();
        String parentSsp = parent.getSchemeSpecificPart();
        StringBuilder builder = new StringBuilder(parentSsp.length() + ARCHIVE_DELIMITER.length() + entry.length());
        builder.append((Object)type).append(':').append(parentScheme);
        String newScheme = builder.toString();
        builder.setLength(0);
        builder.append(parentSsp).append(ARCHIVE_DELIMITER).append(FilenameUtils.separatorsToUnix((String)entry));
        String newSSP = builder.toString();
        try {
            return new URI(newScheme, newSSP, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static enum ImageType {
        ISO("iso"),
        RAR("rar"),
        TAR("tar"),
        ZIP("zip"),
        SEVENZ("sevenz"),
        FAT("fat");

        private String extension;

        private ImageType(String extension) {
            this.extension = extension;
        }

        public String toString() {
            return this.extension;
        }
    }
}

