/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.compat;

import com.sun.jimi.core.JimiEncoder;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiImageColorReducer;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import com.sun.jimi.core.util.ProgressMonitorSupport;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.OutputStream;

public abstract class JimiEncoderBase
extends ProgressMonitorSupport
implements JimiEncoder {
    public static final int MULTIIMAGE = 1;
    public static final int ERROR = 1;
    public static final int DONE = 2;
    public static final int NEXTIMAGE = 4;
    protected AdaptiveRasterImage currentImage;
    protected JimiImageFactory factory;
    protected static final int MAX_COLORS_RGB = -1;

    public AdaptiveRasterImage createAdaptiveRasterImage() {
        return new AdaptiveRasterImage(this.factory);
    }

    public AdaptiveRasterImage createAdaptiveRasterImage(int n, int n2, ColorModel colorModel) {
        AdaptiveRasterImage adaptiveRasterImage = new AdaptiveRasterImage(this.factory);
        adaptiveRasterImage.setSize(n, n2);
        adaptiveRasterImage.setColorModel(colorModel);
        return adaptiveRasterImage;
    }

    public abstract boolean driveEncoder() throws JimiException;

    public void encodeImage(JimiImage jimiImage, OutputStream outputStream) throws JimiException {
        jimiImage.waitFinished();
        if (this.progressListener != null) {
            this.progressListener.setStarted();
        }
        try {
            Object object;
            if (!(jimiImage instanceof JimiRasterImage)) {
                throw new JimiException("Only encodes RasterImages.");
            }
            JimiRasterImage jimiRasterImage = JimiUtil.asJimiRasterImage(jimiImage);
            if (this.getMaxColors() != -1 && !(jimiRasterImage.getColorModel() instanceof IndexColorModel)) {
                object = new JimiImageColorReducer(this.getMaxColors());
                jimiRasterImage = ((JimiImageColorReducer)object).colorReduceFS(jimiRasterImage);
            }
            object = new AdaptiveRasterImage(jimiRasterImage);
            this.currentImage = object;
            this.setNumberOfImages(1);
            this.initSpecificEncoder(outputStream, (AdaptiveRasterImage)object);
            this.setJimiImage((AdaptiveRasterImage)object);
            while (this.driveEncoder()) {
            }
            if (this.progressListener != null) {
                this.progressListener.setFinished();
            }
        }
        catch (JimiException jimiException) {
            if (this.progressListener != null) {
                this.progressListener.setAbort();
            }
            throw jimiException;
        }
    }

    public void encodeImage(JimiImage jimiImage, OutputStream outputStream, ProgressListener progressListener) throws JimiException {
        this.progressListener = progressListener;
        this.encodeImage(jimiImage, outputStream);
    }

    public void encodeImages(JimiImageEnumeration jimiImageEnumeration, OutputStream outputStream) throws JimiException {
        this.setNumberOfImages(jimiImageEnumeration.countImages());
        if (this.progressListener != null) {
            this.progressListener.setStarted();
        }
        try {
            int n;
            Object object;
            JimiRasterImage jimiRasterImage = JimiUtil.asJimiRasterImage(jimiImageEnumeration.getNextImage());
            if (this.getMaxColors() != -1 && !(jimiRasterImage.getColorModel() instanceof IndexColorModel)) {
                object = new JimiImageColorReducer(this.getMaxColors());
                jimiRasterImage = ((JimiImageColorReducer)object).colorReduceFS(jimiRasterImage);
            }
            object = new AdaptiveRasterImage(jimiRasterImage);
            this.currentImage = object;
            this.factory = jimiRasterImage.getFactory();
            this.initSpecificEncoder(outputStream, (AdaptiveRasterImage)object);
            this.setNumberOfImages(jimiImageEnumeration.countImages());
            this.setJimiImage((AdaptiveRasterImage)object);
            do {
                this.driveEncoder();
                n = this.getState();
                if (n != 4) continue;
                object = new AdaptiveRasterImage(JimiUtil.asJimiRasterImage(jimiImageEnumeration.getNextImage()));
                this.setJimiImage((AdaptiveRasterImage)object);
            } while ((n & 1) == 0 && (n & 2) == 0);
            if (n == 1) {
                throw new JimiException("Error during encoding.");
            }
            if (this.progressListener != null) {
                this.progressListener.setFinished();
            }
        }
        catch (JimiException jimiException) {
            if (this.progressListener != null) {
                this.progressListener.setAbort();
            }
            throw jimiException;
        }
    }

    public void encodeImages(JimiImageEnumeration jimiImageEnumeration, OutputStream outputStream, ProgressListener progressListener) throws JimiException {
    }

    protected void freeEncoder() throws JimiException {
    }

    protected int getCapabilties() {
        return 0;
    }

    protected AdaptiveRasterImage getJimiImage() {
        return this.currentImage;
    }

    protected int getMaxColors() {
        return -1;
    }

    protected int getState() {
        return 0;
    }

    protected abstract void initSpecificEncoder(OutputStream var1, AdaptiveRasterImage var2) throws JimiException;

    protected void setJimiImage(AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
    }

    public void setNumberOfImages(int n) {
    }

    public void setProgress(int n) {
        if (this.progressListener != null) {
            this.progressListener.setProgressLevel(n);
        }
    }
}

