/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.io.IOException;
import java.io.InputStream;

public class XMLWrapperStream
extends InputStream {
    private String xmlDecl;
    private String rootStart;
    private String rootEnd;
    private int strIndex;
    private int state;
    private static final int DECL = 0;
    private static final int ROOT_START = 1;
    private static final int CONTENT = 2;
    private static final int ROOT_END = 3;
    private InputStream _wrappedStream;

    public XMLWrapperStream(InputStream wrappedStream, String rootName, String version, String encoding, String standalone) {
        this._wrappedStream = wrappedStream;
        this.xmlDecl = "<?xml version='";
        this.xmlDecl = version == null ? this.xmlDecl + "1.0'" : this.xmlDecl + version + "'";
        if (encoding != null) {
            this.xmlDecl = this.xmlDecl + " encoding='" + encoding + "' ";
        }
        if (standalone != null) {
            this.xmlDecl = this.xmlDecl + " standalone='" + standalone + "' ";
        }
        this.xmlDecl = this.xmlDecl + "?>";
        this.state = 0;
        this.strIndex = 0;
        if (rootName != null) {
            this.rootStart = "<" + rootName + ">";
            this.rootEnd = "</" + rootName + ">";
        } else {
            this.rootStart = "";
            this.rootEnd = "";
        }
    }

    public XMLWrapperStream(InputStream wrappedStream) {
        this(wrappedStream, null, null, null, null);
    }

    public XMLWrapperStream(InputStream wrappedStream, String rootName) {
        this(wrappedStream, rootName, null, null, null);
    }

    @Override
    public int read() throws IOException {
        if (this.state == 0) {
            if (this.strIndex >= this.xmlDecl.length()) {
                this.state = 1;
                this.strIndex = 0;
            } else {
                return this.xmlDecl.charAt(this.strIndex++);
            }
        }
        if (this.state == 1) {
            if (this.strIndex >= this.rootStart.length()) {
                this.state = 2;
            } else {
                return this.rootStart.charAt(this.strIndex++);
            }
        }
        if (this.state == 2) {
            int retval = this._wrappedStream.read();
            if (retval == -1) {
                this.state = 3;
                this.strIndex = 0;
            } else {
                return retval;
            }
        }
        if (this.strIndex >= this.rootEnd.length()) {
            return -1;
        }
        return this.rootEnd.charAt(this.strIndex++);
    }
}

