/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.gzip;

import edu.harvard.hul.ois.jhove.module.gzip.CompressionMethod;
import edu.harvard.hul.ois.jhove.module.gzip.CompressionType;
import edu.harvard.hul.ois.jhove.module.gzip.OperatingSystem;
import java.util.Date;
import org.jwat.gzip.GzipEntry;

public class GzipEntryData {
    protected boolean isNonCompliant;
    protected long offset;
    protected CompressionMethod method;
    protected CompressionType extraFlags;
    protected String fileName;
    protected OperatingSystem os;
    protected String comment;
    protected boolean asciiFlag;
    protected Integer readCrc16;
    protected int computedCrc16;
    protected Date date;
    protected long size = -1L;
    protected long csize = -1L;
    protected long readISize = -1L;
    protected long computedISize = -1L;
    protected int readCrc32;
    protected int computedCrc32;

    public GzipEntryData() {
    }

    public GzipEntryData(GzipEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("'entry' should never be null");
        }
        this.isNonCompliant = !entry.isCompliant();
        this.offset = entry.getStartOffset();
        this.method = CompressionMethod.fromValue(entry.cm);
        this.date = entry.date;
        this.extraFlags = CompressionType.fromValue(entry.xfl);
        this.fileName = entry.fname;
        this.os = OperatingSystem.fromValue(entry.os);
        this.comment = entry.fcomment;
        this.asciiFlag = entry.bFText;
        this.readCrc16 = entry.crc16;
        this.computedCrc16 = entry.comp_crc16;
        this.csize = entry.compressed_size;
        this.size = entry.uncompressed_size;
        this.readCrc32 = entry.crc32;
        this.computedCrc32 = entry.comp_crc32;
        this.readISize = entry.isize;
        this.computedISize = entry.comp_isize;
    }
}

