/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UTF8 {
    public int utf8_c;
    public byte[] chars_read;
    public boolean bValidChar = false;

    public int readUtf8(int c, InputStream in) throws IOException {
        ByteArrayOutputStream charsOut = new ByteArrayOutputStream(4);
        this.utf8_c = 0;
        this.bValidChar = false;
        if ((c & 0x80) == 0) {
            this.bValidChar = true;
            this.utf8_c = c;
        } else {
            int utf8_octets;
            int utf8_read = 1;
            this.bValidChar = true;
            if ((c & 0xE0) == 192) {
                this.utf8_c = c & 0x1F;
                utf8_octets = 2;
            } else if ((c & 0xF0) == 224) {
                this.utf8_c = c & 0xF;
                utf8_octets = 3;
            } else if ((c & 0xF8) == 240) {
                this.utf8_c = c & 7;
                utf8_octets = 4;
            } else {
                this.utf8_c = 0;
                utf8_read = 0;
                utf8_octets = 0;
                this.bValidChar = false;
            }
            while (this.bValidChar && utf8_read < utf8_octets) {
                c = in.read();
                if (c == -1) {
                    this.bValidChar = false;
                    this.chars_read = charsOut.toByteArray();
                    return -1;
                }
                charsOut.write(c);
                if ((c & 0xC0) == 128) {
                    this.utf8_c = this.utf8_c << 6 | c & 0x3F;
                    utf8_read = (byte)(utf8_read + 1);
                    continue;
                }
                this.bValidChar = false;
            }
            if (utf8_read == utf8_octets) {
                switch (utf8_octets) {
                    case 2: {
                        if (this.utf8_c >= 128) break;
                        this.bValidChar = false;
                        break;
                    }
                    case 3: {
                        if (this.utf8_c >= 2048) break;
                        this.bValidChar = false;
                        break;
                    }
                    case 4: {
                        if (this.utf8_c >= 65536) break;
                        this.bValidChar = false;
                    }
                }
            }
            c = this.utf8_c;
        }
        this.chars_read = charsOut.toByteArray();
        return c;
    }

    public int writeUtf8(int c, OutputStream out) throws IOException {
        int b;
        int shift;
        int utf8_octets;
        int utf8_write = 1;
        if (c < 128) {
            out.write(c);
            utf8_octets = 1;
            shift = 0;
        } else if (c < 2048) {
            b = c >> 6 | 0xC0;
            out.write(b);
            utf8_octets = 2;
            shift = 0;
        } else if (c < 65536) {
            b = c >> 12 | 0xE0;
            out.write(b);
            utf8_octets = 3;
            shift = 6;
        } else if (c < 0x110000) {
            b = c >> 18 | 0xF0;
            out.write(b);
            utf8_octets = 4;
            shift = 12;
        } else {
            throw new IOException("Character (0x" + Integer.toHexString(c) + ") not UTF-8 encodable!");
        }
        while (utf8_write < utf8_octets) {
            b = c >> shift & 0x3F | 0x80;
            out.write(b);
            shift -= 6;
            utf8_write = (byte)(utf8_write + 1);
        }
        return utf8_write;
    }
}

