/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.warc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jwat.common.Diagnosis;
import org.jwat.common.Diagnostics;
import org.jwat.common.HeaderLineReader;
import org.jwat.common.UriProfile;
import org.jwat.warc.WarcDigest;
import org.jwat.warc.WarcFieldParsers;
import org.jwat.warc.WarcRecord;

public abstract class WarcReader
implements Closeable {
    protected UriProfile warcTargetUriProfile;
    protected UriProfile uriProfile;
    protected String blockDigestAlgorithm;
    protected String blockDigestEncoding = "base32";
    protected boolean bPayloadDigest = false;
    protected String payloadDigestAlgorithm;
    protected String payloadDigestEncoding = "base32";
    protected boolean bBlockDigest = false;
    protected int recordHeaderMaxSize;
    protected int payloadHeaderMaxSize;
    protected HeaderLineReader lineReader;
    protected HeaderLineReader headerLineReader;
    protected WarcFieldParsers fieldParsers;
    public final Diagnostics<Diagnosis> diagnostics = new Diagnostics();
    protected boolean bIsCompliant = true;
    protected long consumed = 0L;
    protected int records = 0;
    protected int errors = 0;
    protected int warnings = 0;
    protected WarcRecord currentRecord;
    protected Exception iteratorExceptionThrown;

    protected void init() {
        this.warcTargetUriProfile = UriProfile.RFC3986;
        this.uriProfile = UriProfile.RFC3986;
        this.recordHeaderMaxSize = 8192;
        this.payloadHeaderMaxSize = 32768;
        this.lineReader = HeaderLineReader.getReader();
        this.lineReader.bNameValue = false;
        this.lineReader.encoding = 1;
        this.headerLineReader = HeaderLineReader.getReader();
        this.headerLineReader.bNameValue = true;
        this.headerLineReader.encoding = 3;
        this.headerLineReader.bLWS = true;
        this.headerLineReader.bQuotedText = true;
        this.headerLineReader.bEncodedWords = true;
        this.fieldParsers = new WarcFieldParsers();
    }

    public void reset() {
        this.diagnostics.reset();
        this.bIsCompliant = true;
        this.consumed = 0L;
        this.records = 0;
        this.errors = 0;
        this.warnings = 0;
        this.currentRecord = null;
    }

    public boolean isCompliant() {
        return this.bIsCompliant;
    }

    public abstract boolean isCompressed();

    public void setWarcTargetUriProfile(UriProfile uriProfile) {
        if (uriProfile == null) {
            uriProfile = UriProfile.RFC3986;
        }
        this.warcTargetUriProfile = uriProfile;
    }

    public UriProfile getWarcTargetUriProfile() {
        return this.warcTargetUriProfile;
    }

    public void setUriProfile(UriProfile uriProfile) {
        if (uriProfile == null) {
            uriProfile = UriProfile.RFC3986;
        }
        this.uriProfile = uriProfile;
    }

    public UriProfile getUriProfile() {
        return this.uriProfile;
    }

    public boolean getBlockDigestEnabled() {
        return this.bBlockDigest;
    }

    public void setBlockDigestEnabled(boolean enabled) {
        this.bBlockDigest = enabled;
    }

    public boolean getPayloadDigestEnabled() {
        return this.bPayloadDigest;
    }

    public void setPayloadDigestEnabled(boolean enabled) {
        this.bPayloadDigest = enabled;
    }

    public String getBlockDigestAlgorithm() {
        return this.blockDigestAlgorithm;
    }

    public boolean setBlockDigestAlgorithm(String digestAlgorithm) {
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            this.blockDigestAlgorithm = null;
            return true;
        }
        if (WarcDigest.digestAlgorithmLength(digestAlgorithm) > 0) {
            this.blockDigestAlgorithm = digestAlgorithm;
            return true;
        }
        return false;
    }

    public String getPayloadDigestAlgorithm() {
        return this.payloadDigestAlgorithm;
    }

    public boolean setPayloadDigestAlgorithm(String digestAlgorithm) {
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            this.payloadDigestAlgorithm = null;
            return true;
        }
        if (WarcDigest.digestAlgorithmLength(digestAlgorithm) > 0) {
            this.payloadDigestAlgorithm = digestAlgorithm;
            return true;
        }
        return false;
    }

    public String getBlockDigestEncoding() {
        return this.blockDigestEncoding;
    }

    public void setBlockDigestEncoding(String encodingScheme) {
        this.blockDigestEncoding = encodingScheme != null && encodingScheme.length() > 0 ? encodingScheme.toLowerCase() : null;
    }

    public String getPayloadDigestEncoding() {
        return this.payloadDigestEncoding;
    }

    public void setPayloadDigestEncoding(String encodingScheme) {
        this.payloadDigestEncoding = encodingScheme != null && encodingScheme.length() > 0 ? encodingScheme.toLowerCase() : null;
    }

    public int getRecordHeaderMaxSize() {
        return this.recordHeaderMaxSize;
    }

    public void setRecordHeaderMaxSize(int size) {
        this.recordHeaderMaxSize = size;
    }

    public int getPayloadHeaderMaxSize() {
        return this.payloadHeaderMaxSize;
    }

    public void setPayloadHeaderMaxSize(int size) {
        this.payloadHeaderMaxSize = size;
    }

    @Override
    public abstract void close();

    protected abstract void recordClosed();

    public abstract long getStartOffset();

    public abstract long getOffset();

    public abstract long getConsumed();

    public abstract WarcRecord getNextRecord() throws IOException;

    public abstract WarcRecord getNextRecordFrom(InputStream var1, long var2) throws IOException;

    public abstract WarcRecord getNextRecordFrom(InputStream var1, long var2, int var4) throws IOException;

    public Exception getIteratorExceptionThrown() {
        return this.iteratorExceptionThrown;
    }

    public Iterator<WarcRecord> iterator() {
        return new Iterator<WarcRecord>(){
            private WarcRecord next;
            private WarcRecord current;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    WarcReader.this.iteratorExceptionThrown = null;
                    try {
                        this.next = WarcReader.this.getNextRecord();
                    }
                    catch (IOException e) {
                        WarcReader.this.iteratorExceptionThrown = e;
                    }
                }
                return this.next != null;
            }

            @Override
            public WarcRecord next() {
                if (this.next == null) {
                    WarcReader.this.iteratorExceptionThrown = null;
                    try {
                        this.next = WarcReader.this.getNextRecord();
                    }
                    catch (IOException e) {
                        WarcReader.this.iteratorExceptionThrown = e;
                    }
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

