/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.javaclass;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class JavaClassUtils {
    private static final Class[] parameters = new Class[]{URL.class};

    public static void addURLToClassLoader(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        if (!JavaClassUtils.urlExistInClassLoader(sysloader, u)) {
            try {
                Method method = sysclass.getDeclaredMethod("addURL", parameters);
                method.setAccessible(true);
                method.invoke((Object)sysloader, u);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IOException("Error, could not add URL to system classloader");
            }
        }
    }

    private static boolean urlExistInClassLoader(URLClassLoader sysloader, URL u) {
        boolean result = false;
        URL[] urls = sysloader.getURLs();
        if (urls != null) {
            for (URL url : urls) {
                if (!url.equals(u)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

