/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.javaclass;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger log = Logger.getLogger(PluginClassLoader.class);
    private Map<String, Class<?>> hmClass = new HashMap();
    private ProtectionDomain pd = this.getClass().getProtectionDomain();
    private List<JarFileInfo> lstJarFile = new ArrayList<JarFileInfo>();
    File dirTemp;

    public PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addJar(File fileJar, double version, File tempDirectory) {
        try {
            JarFileInfo jarFileInfo = new JarFileInfo(new JarFile(fileJar), fileJar.getName(), null, null);
            this.dirTemp = tempDirectory;
            this.loadJar(jarFileInfo);
            this.dirTemp.deleteOnExit();
        }
        catch (IOException e) {
            log.error((Object)("Failed loading " + fileJar.getName() + " V:" + version), (Throwable)e);
        }
    }

    private void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        this.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Directory " + directory + " could not be deleted.");
        }
    }

    private void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            throw new FileNotFoundException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IOException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            this.forceDelete(file);
        }
    }

    private void forceDelete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.deleteDirectory(file);
        } else if (!file.delete()) {
            throw new IOException("File " + file + " could not be deleted.");
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String sClassName) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(sClassName);
        if (loadedClass == null) {
            try {
                loadedClass = this.findClass(sClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (loadedClass == null) {
                try {
                    loadedClass = this.findJarClass(sClassName);
                }
                catch (JarClassLoaderException jarClassLoaderException) {
                    // empty catch block
                }
                if (loadedClass == null) {
                    loadedClass = super.loadClass(sClassName);
                }
            }
        }
        return loadedClass;
    }

    private Class<?> findJarClass(String sClassName) throws JarClassLoaderException {
        Class<?> c = this.hmClass.get(sClassName);
        if (c != null) {
            return c;
        }
        String sName = sClassName.replace('.', '/') + ".class";
        JarEntryInfo inf = this.findJarEntry(sName);
        String jarSimpleName = null;
        if (inf != null) {
            jarSimpleName = inf.jarFileInfo.simpleName;
            this.definePackage(sClassName, inf);
            byte[] a_by = inf.getJarBytes();
            try {
                c = this.defineClass(sClassName, a_by, 0, a_by.length, this.pd);
            }
            catch (ClassFormatError e) {
                throw new JarClassLoaderException(null, e);
            }
        }
        if (c == null) {
            throw new JarClassLoaderException(sClassName);
        }
        this.hmClass.put(sClassName, c);
        log.debug((Object)("Loaded " + sClassName + " by " + this.getClass().getName() + " from JAR " + jarSimpleName));
        return c;
    }

    private void definePackage(String sClassName, JarEntryInfo inf) throws IllegalArgumentException {
        String sPackageName;
        int pos = sClassName.lastIndexOf(46);
        String string = sPackageName = pos > 0 ? sClassName.substring(0, pos) : "";
        if (this.getPackage(sPackageName) == null) {
            JarFileInfo jfi = inf.jarFileInfo;
            this.definePackage(sPackageName, jfi.getSpecificationTitle(), jfi.getSpecificationVersion(), jfi.getSpecificationVendor(), jfi.getImplementationTitle(), jfi.getImplementationVersion(), jfi.getImplementationVendor(), jfi.getSealURL());
        }
    }

    private JarEntryInfo findJarEntry(String sName) {
        for (JarFileInfo jarFileInfo : this.lstJarFile) {
            JarFile jarFile = jarFileInfo.jarFile;
            JarEntry jarEntry = jarFile.getJarEntry(sName);
            if (jarEntry == null) continue;
            return new JarEntryInfo(jarFileInfo, jarEntry);
        }
        return null;
    }

    private void loadJar(JarFileInfo jarFileInfo) throws IOException {
        this.lstJarFile.add(jarFileInfo);
        try {
            Enumeration<JarEntry> en = jarFileInfo.jarFile.entries();
            String EXT_JAR = ".jar";
            while (en.hasMoreElements()) {
                String s;
                JarEntry je = en.nextElement();
                if (je.isDirectory() || (s = je.getName().toLowerCase()).lastIndexOf(".jar") != s.length() - ".jar".length()) continue;
                JarEntryInfo inf = new JarEntryInfo(jarFileInfo, je);
                File fileTemp = this.createTempFile(inf);
                log.debug((Object)("Loading inner JAR " + inf.jarEntry + " from temp file " + this.getFilename4Log(fileTemp)));
                this.loadJar(new JarFileInfo(new JarFile(fileTemp), inf.getName(), jarFileInfo, fileTemp));
            }
        }
        catch (JarClassLoaderException e) {
            throw new RuntimeException("ERROR on loading inner JAR: " + e.getMessageAll());
        }
    }

    private String getFilename4Log(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private File createTempFile(JarEntryInfo inf) throws JarClassLoaderException {
        File fileTmp = null;
        try {
            fileTmp = File.createTempFile(inf.getName() + ".", null, this.dirTemp);
            fileTmp.deleteOnExit();
            byte[] a_by = inf.getJarBytes();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileTmp));
            os.write(a_by);
            os.close();
            return fileTmp;
        }
        catch (IOException e) {
            throw new JarClassLoaderException(String.format("Cannot create temp file '%s' for %s", fileTmp, inf.jarEntry), e);
        }
    }

    private static class JarClassLoaderException
    extends Exception {
        JarClassLoaderException(String sMsg) {
            super(sMsg);
        }

        JarClassLoaderException(String sMsg, Throwable eCause) {
            super(sMsg, eCause);
        }

        String getMessageAll() {
            StringBuilder sb = new StringBuilder();
            for (Throwable e = this; e != null; e = e.getCause()) {
                String sMsg;
                if (sb.length() > 0) {
                    sb.append(" / ");
                }
                if ((sMsg = e.getMessage()) == null || sMsg.length() == 0) {
                    sMsg = e.getClass().getSimpleName();
                }
                sb.append(sMsg);
            }
            return sb.toString();
        }
    }

    private static class JarFileInfo {
        JarFile jarFile;
        String simpleName;
        Manifest mf;

        JarFileInfo(JarFile jarFile, String simpleName, JarFileInfo jarFileParent, File fileDeleteOnExit) {
            this.simpleName = (jarFileParent == null ? "" : jarFileParent.simpleName + "!") + simpleName;
            this.jarFile = jarFile;
            try {
                this.mf = jarFile.getManifest();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.mf == null) {
                this.mf = new Manifest();
            }
        }

        String getSpecificationTitle() {
            return this.mf.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_TITLE);
        }

        String getSpecificationVersion() {
            return this.mf.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
        }

        String getSpecificationVendor() {
            return this.mf.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VENDOR);
        }

        String getImplementationTitle() {
            return this.mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        }

        String getImplementationVersion() {
            return this.mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }

        String getImplementationVendor() {
            return this.mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }

        URL getSealURL() {
            String seal = this.mf.getMainAttributes().getValue(Attributes.Name.SEALED);
            if (seal != null) {
                try {
                    return new URL(seal);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class JarEntryInfo {
        JarFileInfo jarFileInfo;
        JarEntry jarEntry;

        JarEntryInfo(JarFileInfo jarFileInfo, JarEntry jarEntry) {
            this.jarFileInfo = jarFileInfo;
            this.jarEntry = jarEntry;
        }

        String getName() {
            return this.jarEntry.getName().replace('/', '_');
        }

        public String toString() {
            return "JAR: " + this.jarFileInfo.jarFile.getName() + " ENTRY: " + this.jarEntry;
        }

        byte[] getJarBytes() throws JarClassLoaderException {
            FilterInputStream dis = null;
            byte[] a_by = null;
            try {
                long lSize = this.jarEntry.getSize();
                if (lSize <= 0L || lSize >= Integer.MAX_VALUE) {
                    throw new JarClassLoaderException("Invalid size " + lSize + " for entry " + this.jarEntry);
                }
                a_by = new byte[(int)lSize];
                InputStream is = this.jarFileInfo.jarFile.getInputStream(this.jarEntry);
                dis = new DataInputStream(is);
                ((DataInputStream)dis).readFully(a_by);
            }
            catch (IOException e) {
                throw new JarClassLoaderException(null, e);
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return a_by;
        }
    }
}

