/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import com.exlibris.core.infra.common.sax.UnEscapeSequenceXMLFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxRipEvents
extends DefaultHandler {
    private Map<String, Map<String, Integer>> results = null;
    private static final String TAG_DIGIPROV = "mets:digiprovMD";
    private static final String TAG_SECTION = "section";
    private static final String TAG_KEY = "key";
    private static final String ATTRIBUTE_ID = "id";
    private static final String AMD_DIGIPROV_SUFFIX = "-amd-digiprov";
    private static final String ID_FILE_PREFIX = "FL";
    private static final String ID_REP_PREFIX = "REP";
    private static final String IE_VAL = "ie-amd-digiprov";
    private static final String ID_EVENT = "event";
    private static final String ID_EVENT_TYPE = "eventIdentifierValue";
    private boolean inEventSection = false;
    private boolean readEventType = false;
    private boolean isUnderDigiprovTag = false;
    private String currentResultsKey = null;
    private String currentEventType = null;
    private final String IE = "IE";
    private final String REP = "REP";
    private final String FILE = "File";

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (TAG_DIGIPROV.equals(qName)) {
            this.isUnderDigiprovTag = true;
            String attributeValue = this.getAttributeValueByQName(attributes, ATTRIBUTE_ID);
            if (attributeValue != null) {
                this.currentResultsKey = IE_VAL.equals(attributeValue) ? "IE" : (attributeValue.startsWith(ID_REP_PREFIX) && attributeValue.endsWith(AMD_DIGIPROV_SUFFIX) ? ID_REP_PREFIX : (attributeValue.startsWith(ID_FILE_PREFIX) && attributeValue.endsWith(AMD_DIGIPROV_SUFFIX) ? "File" : null));
            }
        }
        if (!this.isUnderDigiprovTag) {
            return;
        }
        if (TAG_SECTION.equals(qName) && ID_EVENT.equals(this.getAttributeValueByQName(attributes, ATTRIBUTE_ID))) {
            this.inEventSection = true;
        }
        if (!this.inEventSection) {
            return;
        }
        if (TAG_KEY.equals(qName) && ID_EVENT_TYPE.equals(this.getAttributeValueByQName(attributes, ATTRIBUTE_ID))) {
            this.readEventType = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.isUnderDigiprovTag &= !TAG_DIGIPROV.equals(qName);
        this.readEventType &= !TAG_KEY.equals(qName);
        this.inEventSection &= !TAG_SECTION.equals(qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.readEventType) {
            if (this.results.get(this.currentResultsKey) == null) {
                this.results.put(this.currentResultsKey, new HashMap());
            }
            this.currentEventType = this.getValue(ch, start, length);
            if (this.results.get(this.currentResultsKey).get(this.currentEventType) == null) {
                this.results.get(this.currentResultsKey).put(this.currentEventType, 1);
            } else {
                this.results.get(this.currentResultsKey).put(this.currentEventType, this.results.get(this.currentResultsKey).get(this.currentEventType) + 1);
            }
        }
    }

    public Map<String, Map<String, Integer>> getResults() {
        return this.results;
    }

    public void parse(InputStream is) throws SAXException, IOException {
        this.results = new HashMap<String, Map<String, Integer>>();
        try {
            UnEscapeSequenceXMLFilter xmlFilter = new UnEscapeSequenceXMLFilter(XMLReaderFactory.createXMLReader());
            xmlFilter.setContentHandler(this);
            xmlFilter.parse(new InputSource(is));
        }
        finally {
            is.close();
        }
    }

    private String getValue(char[] ch, int start, int length) {
        return new StringBuilder().append(ch, start, length).toString();
    }

    private String getAttributeValueByQName(Attributes attributes, String qName) {
        if (attributes == null) {
            return null;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!qName.equalsIgnoreCase(attributes.getQName(i))) continue;
            return attributes.getValue(i);
        }
        return null;
    }
}

