/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import java.util.HashSet;

public class UserPasswordGenerator {
    public static String getPassword(int n) {
        if (n < 3) {
            n = 3;
        }
        char[] password = new char[n];
        int randomCharacter = 65;
        int randomGroup = 0;
        password = UserPasswordGenerator.ensureEachGroup(password);
        for (int i = 3; i < n; ++i) {
            randomGroup = (int)(Math.random() * 3.0);
            switch (randomGroup) {
                case 0: {
                    randomCharacter = UserPasswordGenerator.getRandomDigit();
                    break;
                }
                case 1: {
                    randomCharacter = UserPasswordGenerator.getRandomLowerCaseCharDigit();
                    break;
                }
                case 2: {
                    randomCharacter = UserPasswordGenerator.getRandomUpperCaseCharDigit();
                }
            }
            password[i] = (char)randomCharacter;
        }
        return new String(password);
    }

    private static char[] ensureEachGroup(char[] password) {
        int randomGroup = (int)(Math.random() * 3.0);
        switch (randomGroup) {
            case 0: {
                password[0] = (char)UserPasswordGenerator.getRandomDigit();
                password[1] = (char)UserPasswordGenerator.getRandomLowerCaseCharDigit();
                password[2] = (char)UserPasswordGenerator.getRandomUpperCaseCharDigit();
                break;
            }
            case 1: {
                password[0] = (char)UserPasswordGenerator.getRandomLowerCaseCharDigit();
                password[1] = (char)UserPasswordGenerator.getRandomDigit();
                password[2] = (char)UserPasswordGenerator.getRandomUpperCaseCharDigit();
                break;
            }
            case 2: {
                password[0] = (char)UserPasswordGenerator.getRandomUpperCaseCharDigit();
                password[1] = (char)UserPasswordGenerator.getRandomDigit();
                password[2] = (char)UserPasswordGenerator.getRandomLowerCaseCharDigit();
            }
        }
        return password;
    }

    public static int getRandomDigit() {
        return 48 + (int)(Math.random() * 10.0);
    }

    public static int getRandomLowerCaseCharDigit() {
        return 97 + (int)(Math.random() * 26.0);
    }

    public static int getRandomUpperCaseCharDigit() {
        return 65 + (int)(Math.random() * 26.0);
    }

    public static void main(String[] args) {
        HashSet<String> passSet = new HashSet<String>();
        int c = 0;
        for (int i = 0; i < 10000; ++i) {
            String intStr = UserPasswordGenerator.getPassword(10);
            if (passSet.contains(intStr)) {
                ++c;
                System.out.println("FAILED : ");
            } else {
                passSet.add(intStr);
            }
            System.out.println(intStr);
        }
        System.out.println("ALL FAILED : " + c);
    }
}

