/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.HPersistent;
import java.io.UnsupportedEncodingException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.Index;

@Entity
@Table(name="HFREVENTKEYS")
@org.hibernate.annotations.Table(appliesTo="HFREVENTKEYS", indexes={@Index(name="HFREVENTKEYS_EVENT", columnNames={"EVENT_ID"}), @Index(name="HFREVENTKEYS_EVENT_NAME_VALUE", columnNames={"EVENT_ID", "NAME", "VALUE"})})
public class HFrEventKeys
extends HPersistent {
    private static final int VALUE_LENGTH = 512;
    private static final long serialVersionUID = 1L;
    static final String UTF8 = "UTF-8";
    private String name;
    private String value;

    @Column(name="name")
    @Index(name="HFREVENTKEYS_NAME")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="value", length=512)
    @Index(name="HFREVENTKEYS_VALUE")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        int length = HFrEventKeys.getNullSafeLength(value);
        String newString = HFrEventKeys.getLimitedLengthString(value, 512);
        this.value = length < 170 ? newString : HFrEventKeys.getLimitedUTF8LengthString(newString, 512);
    }

    public static String getLimitedUTF8LengthString(String str, int length) {
        if (null == str) {
            return str;
        }
        int newLength = length;
        String newString = str;
        try {
            int l = str.getBytes(UTF8).length;
            if (l <= length) {
                return str;
            }
            while (l > length) {
                newString = HFrEventKeys.getLimitedLengthString(newString, --newLength);
                l = newString.getBytes(UTF8).length;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
        return newString;
    }

    public static String getLimitedLengthString(String str, int length) {
        if (HFrEventKeys.getNullSafeLength(str) > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static int getNullSafeLength(String str) {
        if (null != str) {
            return str.length();
        }
        return -1;
    }
}

