/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.HFrEvent;
import com.exlibris.core.infra.model.HFrTransientEventStatistic;
import com.exlibris.core.infra.model.HPersistent;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class HFrEventStatistics
extends HPersistent {
    private static final long serialVersionUID = 1L;
    private String eventType;
    private HFrEvent.Category eventCategory;
    private String eventContext;
    private String machineAddress;
    private String module;
    private String subModule;
    private Calendar statisticDate;
    private String institution;
    private String userOnCumpus;
    private String userGroup;
    private Integer eventCount;
    private Integer eventCount2;
    private Integer eventCount3;
    private Integer avgDuration;
    private HFrEvent.Severity eventSeverity;
    public static Comparator<HFrEventStatistics> typeComparator = new Comparator<HFrEventStatistics>(){

        @Override
        public int compare(HFrEventStatistics o1, HFrEventStatistics o2) {
            return o1.compareTo(o2);
        }
    };

    public HFrEventStatistics() {
    }

    public HFrEventStatistics(HFrTransientEventStatistic event) {
        this.eventType = event.getEventType();
        this.eventCategory = event.getEventCategory();
        this.eventContext = event.getEventContext();
        this.machineAddress = event.getMachineAddress();
        this.module = event.getModule();
        this.subModule = event.getSubModule();
        this.institution = event.getScope();
        this.userOnCumpus = event.getUserOnCampus();
        this.userGroup = event.getUserGroup();
        this.eventSeverity = event.getSeverity();
    }

    @Column(length=255, name="Event_Type")
    @Index(name="HFREVENTSTATISTICS_EVENTTYPE")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Column(length=255, name="Event_Category")
    public HFrEvent.Category getEventCategory() {
        return this.eventCategory;
    }

    public void setEventCategory(HFrEvent.Category eventCategory) {
        this.eventCategory = eventCategory;
    }

    @Column(length=4000, name="Event_Context")
    public String getEventContext() {
        return this.eventContext;
    }

    public void setEventContext(String eventContext) {
        this.eventContext = eventContext;
    }

    @Column(length=255, name="Machine_Address")
    public String getMachineAddress() {
        return this.machineAddress;
    }

    public void setMachineAddress(String machineAddress) {
        this.machineAddress = machineAddress;
    }

    @Column(length=255, name="module")
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Column(length=255, name="Sub_Module")
    public String getSubModule() {
        return this.subModule;
    }

    public void setSubModule(String subModule) {
        this.subModule = subModule;
    }

    @Column(name="Statistic_Date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getStatisticDate() {
        return this.statisticDate;
    }

    public void setStatisticDate(Calendar statisticDate) {
        this.statisticDate = statisticDate;
    }

    @Column(length=255, name="institution")
    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    @Column(length=255, name="User_On_Cumpus")
    public String getUserOnCumpus() {
        return this.userOnCumpus;
    }

    public void setUserOnCumpus(String userOnCumpus) {
        this.userOnCumpus = userOnCumpus;
    }

    @Column(length=255, name="User_Group")
    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    @Column(name="Event_Count")
    public Integer getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(Integer eventCount) {
        this.eventCount = eventCount;
    }

    @Column(name="Event_Count2")
    public Integer getEventCount2() {
        return this.eventCount2;
    }

    public void setEventCount2(Integer eventCount2) {
        this.eventCount2 = eventCount2;
    }

    @Column(name="Event_Count3")
    public Integer getEventCount3() {
        return this.eventCount3;
    }

    public void setEventCount3(Integer eventCount3) {
        this.eventCount3 = eventCount3;
    }

    @Column(name="Avg_Duration")
    public Integer getAvgDuration() {
        return this.avgDuration;
    }

    public void setAvgDuration(Integer avgDuration) {
        this.avgDuration = avgDuration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.avgDuration == null ? 0 : this.avgDuration.hashCode());
        result = 31 * result + (this.eventCategory == null ? 0 : this.eventCategory.hashCode());
        result = 31 * result + (this.eventContext == null ? 0 : this.eventContext.hashCode());
        result = 31 * result + (this.eventCount == null ? 0 : this.eventCount.hashCode());
        result = 31 * result + (this.eventCount2 == null ? 0 : this.eventCount2.hashCode());
        result = 31 * result + (this.eventCount3 == null ? 0 : this.eventCount3.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.eventSeverity == null ? 0 : this.eventSeverity.hashCode());
        result = 31 * result + (this.institution == null ? 0 : this.institution.hashCode());
        result = 31 * result + (this.machineAddress == null ? 0 : this.machineAddress.hashCode());
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.statisticDate == null ? 0 : this.statisticDate.hashCode());
        result = 31 * result + (this.subModule == null ? 0 : this.subModule.hashCode());
        result = 31 * result + (this.userGroup == null ? 0 : this.userGroup.hashCode());
        result = 31 * result + (this.userOnCumpus == null ? 0 : this.userOnCumpus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HFrEventStatistics other = (HFrEventStatistics)obj;
        if (this.avgDuration == null ? other.avgDuration != null : !this.avgDuration.equals(other.avgDuration)) {
            return false;
        }
        if (this.eventCategory == null ? other.eventCategory != null : !this.eventCategory.equals((Object)other.eventCategory)) {
            return false;
        }
        if (this.eventContext == null ? other.eventContext != null : !this.eventContext.equals(other.eventContext)) {
            return false;
        }
        if (this.eventCount == null ? other.eventCount != null : !this.eventCount.equals(other.eventCount)) {
            return false;
        }
        if (this.eventCount2 == null ? other.eventCount2 != null : !this.eventCount2.equals(other.eventCount2)) {
            return false;
        }
        if (this.eventCount3 == null ? other.eventCount3 != null : !this.eventCount3.equals(other.eventCount3)) {
            return false;
        }
        if (this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType)) {
            return false;
        }
        if (this.eventSeverity == null ? other.eventSeverity != null : !this.eventSeverity.equals((Object)other.eventSeverity)) {
            return false;
        }
        if (this.institution == null ? other.institution != null : !this.institution.equals(other.institution)) {
            return false;
        }
        if (this.machineAddress == null ? other.machineAddress != null : !this.machineAddress.equals(other.machineAddress)) {
            return false;
        }
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        if (this.statisticDate == null ? other.statisticDate != null : !this.statisticDate.equals(other.statisticDate)) {
            return false;
        }
        if (this.subModule == null ? other.subModule != null : !this.subModule.equals(other.subModule)) {
            return false;
        }
        if (this.userGroup == null ? other.userGroup != null : !this.userGroup.equals(other.userGroup)) {
            return false;
        }
        return !(this.userOnCumpus == null ? other.userOnCumpus != null : !this.userOnCumpus.equals(other.userOnCumpus));
    }

    @Column(length=20, name="Event_Severity")
    public HFrEvent.Severity getEventSeverity() {
        return this.eventSeverity;
    }

    public void setEventSeverity(HFrEvent.Severity eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    @Override
    public int compareTo(Object o) {
        HFrEventStatistics event = (HFrEventStatistics)o;
        int result = 0;
        if (this.eventType != null) {
            result = this.getEventType().compareTo(event.getEventType());
        }
        if (result == 0 && this.module != null) {
            result = this.module.compareTo(event.getModule());
        }
        if (result == 0 && this.subModule != null) {
            result = this.subModule.compareTo(event.getSubModule());
        }
        if (result == 0 && this.eventSeverity != null) {
            result = this.eventSeverity.compareTo(event.getEventSeverity());
        }
        return result;
    }

    public boolean isInList(List<HFrEventStatistics> list) {
        for (HFrEventStatistics event : list) {
            if (this.compareTo(event) != 0) continue;
            return true;
        }
        return false;
    }
}

