/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.HFrEvent;
import com.exlibris.core.infra.model.HPersistent;
import java.util.Calendar;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="HFrTransientEventStatistic")
@AttributeOverride(name="id", column=@Column(name="Transient_Event_ID"))
public class HFrTransientEventStatistic
extends HPersistent {
    private static final long serialVersionUID = 1L;
    private String eventType;
    private HFrEvent.Category eventCategory;
    private HFrEvent.Severity severity;
    private Calendar eventDate;
    private String machineAddress;
    private String module;
    private String subModule;
    private Integer eventDuration;
    private String eventValues;
    private String eventDescription;
    private String scope;
    private String userGroup;
    private String userName;
    private String userOnCampus;
    private String eventContext;

    public HFrTransientEventStatistic() {
    }

    public HFrTransientEventStatistic(HFrEvent event) {
        this.eventType = event.getEventType();
        this.eventCategory = event.getEventCategory();
        this.severity = event.getEventSeverity();
        this.eventDate = event.getEventDate();
        this.machineAddress = event.getMachineAddress();
        this.module = event.getModule();
        this.subModule = event.getSubModule();
        this.eventDuration = event.getEventDuration();
        this.eventValues = event.getEventValues();
        this.eventDescription = event.getEventValues();
        this.scope = event.getScope();
        this.userGroup = event.getUserGroup();
        this.userName = event.getUserName();
        this.userOnCampus = event.getUserOnCampus();
        this.eventContext = event.getEventContext();
    }

    @Column(length=20, name="Event_Type", nullable=false)
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Column(length=20, name="Event_Category")
    public HFrEvent.Category getEventCategory() {
        return this.eventCategory;
    }

    public void setEventCategory(HFrEvent.Category eventCategory) {
        this.eventCategory = eventCategory;
    }

    @Column(length=20, name="severity", nullable=false)
    public HFrEvent.Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(HFrEvent.Severity severity) {
        this.severity = severity;
    }

    @Column(name="Event_Date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Calendar eventDate) {
        this.eventDate = eventDate;
    }

    @Column(length=255, name="Machine_Address")
    public String getMachineAddress() {
        return this.machineAddress;
    }

    public void setMachineAddress(String machineAddress) {
        this.machineAddress = machineAddress;
    }

    @Column(length=255, name="module")
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Column(length=255, name="Sub_Module")
    public String getSubModule() {
        return this.subModule;
    }

    public void setSubModule(String subModule) {
        this.subModule = subModule;
    }

    @Column(name="Event_Duration")
    public Integer getEventDuration() {
        return this.eventDuration;
    }

    public void setEventDuration(Integer eventDuration) {
        this.eventDuration = eventDuration;
    }

    @Column(length=4000, name="Event_Values")
    public String getEventValues() {
        return this.eventValues;
    }

    public void setEventValues(String eventValues) {
        this.eventValues = eventValues;
    }

    @Column(length=4000, name="Event_Description")
    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }

    @Column(length=100, name="Scope", nullable=false)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Column(length=100, name="User_Group")
    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    @Column(length=100, name="User_Name", nullable=false)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(length=20, name="Source_On_Campus")
    public String getUserOnCampus() {
        return this.userOnCampus;
    }

    public void setUserOnCampus(String sourceOnCampus) {
        this.userOnCampus = sourceOnCampus;
    }

    @Column(length=4000, name="Event_Context")
    public String getEventContext() {
        return this.eventContext;
    }

    public void setEventContext(String eventContext) {
        this.eventContext = eventContext;
    }

    @Transient
    public HFrEvent getEvent() {
        HFrEvent event = new HFrEvent();
        event.setEventType(this.eventType);
        event.setEventCategory(this.eventCategory);
        event.setEventSeverity(this.severity);
        event.setEventDate(this.eventDate);
        event.setMachineAddress(this.machineAddress);
        event.setModule(this.module);
        event.setSubModule(this.subModule);
        event.setEventDuration(this.eventDuration);
        event.setEventValues(this.eventValues);
        event.setEventValues(this.eventDescription);
        event.setScope(this.scope);
        event.setUserGroup(this.userGroup);
        event.setUserName(this.userName);
        event.setUserOnCampus(this.userOnCampus);
        event.setEventContext(this.eventContext);
        return event;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventCategory == null ? 0 : this.eventCategory.hashCode());
        result = 31 * result + (this.eventContext == null ? 0 : this.eventContext.hashCode());
        result = 31 * result + (this.eventDate == null ? 0 : this.eventDate.hashCode());
        result = 31 * result + (this.eventDescription == null ? 0 : this.eventDescription.hashCode());
        result = 31 * result + (this.eventDuration == null ? 0 : this.eventDuration.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.eventValues == null ? 0 : this.eventValues.hashCode());
        result = 31 * result + (this.machineAddress == null ? 0 : this.machineAddress.hashCode());
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.subModule == null ? 0 : this.subModule.hashCode());
        result = 31 * result + (this.userGroup == null ? 0 : this.userGroup.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        result = 31 * result + (this.userOnCampus == null ? 0 : this.userOnCampus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HFrTransientEventStatistic other = (HFrTransientEventStatistic)obj;
        if (this.eventCategory == null ? other.eventCategory != null : !this.eventCategory.equals((Object)other.eventCategory)) {
            return false;
        }
        if (this.eventContext == null ? other.eventContext != null : !this.eventContext.equals(other.eventContext)) {
            return false;
        }
        if (this.eventDate == null ? other.eventDate != null : !this.eventDate.equals(other.eventDate)) {
            return false;
        }
        if (this.eventDescription == null ? other.eventDescription != null : !this.eventDescription.equals(other.eventDescription)) {
            return false;
        }
        if (this.eventDuration == null ? other.eventDuration != null : !this.eventDuration.equals(other.eventDuration)) {
            return false;
        }
        if (this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType)) {
            return false;
        }
        if (this.eventValues == null ? other.eventValues != null : !this.eventValues.equals(other.eventValues)) {
            return false;
        }
        if (this.machineAddress == null ? other.machineAddress != null : !this.machineAddress.equals(other.machineAddress)) {
            return false;
        }
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.severity == null ? other.severity != null : !this.severity.equals((Object)other.severity)) {
            return false;
        }
        if (this.subModule == null ? other.subModule != null : !this.subModule.equals(other.subModule)) {
            return false;
        }
        if (this.userGroup == null ? other.userGroup != null : !this.userGroup.equals(other.userGroup)) {
            return false;
        }
        if (this.userName == null ? other.userName != null : !this.userName.equals(other.userName)) {
            return false;
        }
        return !(this.userOnCampus == null ? other.userOnCampus != null : !this.userOnCampus.equals(other.userOnCampus));
    }
}

