/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.resource;

import com.exlibris.core.infra.model.resource.EREException;
import com.exlibris.core.infra.model.resource.ParseSRWResponse;
import com.exlibris.core.infra.model.resource.SRWRecord;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ERESearchResultsSet {
    static Log log = LogFactory.getLog(ERESearchResultsSet.class);
    private List<SRWRecord> resultsObjects = new ArrayList<SRWRecord>();
    int numberOfRecords = 0;
    boolean hasMore = false;
    private ParseSRWResponse srwParser = null;

    public ERESearchResultsSet(String input) throws EREException {
        this.srwParser = new ParseSRWResponse(input);
        this.setResults();
    }

    private void setResults() {
        if (this.srwParser != null) {
            this.resultsObjects = this.srwParser.getResultsObjects();
            this.numberOfRecords = this.srwParser.getNumberOfRecords();
            this.hasMore = this.srwParser.getNumberOfRecords() - this.srwParser.getRecordsRetrived() > 0;
        }
    }

    public List<SRWRecord> getResultsObjects() {
        return this.resultsObjects;
    }

    public void setResultsObjects(List<SRWRecord> resultsObjects) {
        this.resultsObjects = resultsObjects;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public void setNumberOfRecords(int numberOfRecords) {
        this.numberOfRecords = numberOfRecords;
    }
}

