/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.queue;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.queue.OracleAQWorkQueueFactory;
import com.exlibris.core.infra.svc.api.queue.QueueConstants;
import com.exlibris.core.infra.svc.api.queue.WorkQueue;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Topic;

public class OracleAQWorkQueueMDB<T> {
    private static final ExLogger log = ExLogger.getExLogger(OracleAQWorkQueueMDB.class, "DEP");

    public void onMessage(Message message, QueueConstants.messageType type) throws Exception {
        HashMap<String, Object> work = null;
        String destinationName = null;
        try {
            try {
                if (message instanceof ObjectMessage) {
                    work = ((ObjectMessage)message).getObject();
                } else if (message instanceof MapMessage) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    MapMessage mapMessage = (MapMessage)message;
                    Enumeration mapNames = mapMessage.getMapNames();
                    while (mapNames.hasMoreElements()) {
                        String key = (String)mapNames.nextElement();
                        Object value = mapMessage.getObject(key);
                        map.put(key, value);
                    }
                    work = map;
                }
            }
            catch (Throwable e) {
                log.debug((Object)("failed to dequeue from work queue " + destinationName + ". Exception: " + e.getMessage()), e, new String[0]);
            }
            destinationName = type.equals((Object)QueueConstants.messageType.TOPIC) ? ((Topic)message.getJMSDestination()).getTopicName() : ((Queue)message.getJMSDestination()).getQueueName();
        }
        catch (Exception e) {
            log.error("failed to dequeue from work queue " + destinationName + ". Exception: " + e.getMessage(), e, new String[0]);
            throw e;
        }
        if (work != null) {
            try {
                this.log(work, destinationName, "started");
                Class<?> c = work.getClass();
                OracleAQWorkQueueFactory<?> workQueueFactory = OracleAQWorkQueueFactory.getFactory(c);
                WorkQueue<?> workQueue = workQueueFactory.getWorkQueue(destinationName);
                workQueue.notifyListeners(work);
                this.log(work, destinationName, "finished");
            }
            catch (Exception e) {
                log.error("processing " + ((Object)work).toString() + " from work queue " + destinationName + " failed. Exception: " + e.getMessage(), new String[0]);
                throw new RuntimeException(e);
            }
        }
        if ("SHARED_CACHE_TOPIC".equals(destinationName)) {
            log.info("workaround for refreshing cache from eclipse plugin");
            CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
            try {
                codeTableManager.loadCodeTablesTreeCache("CRS00", true);
                log.info("Code tables cache reload... ");
            }
            catch (Exception e) {
                log.error("Code tables reload failed", e, new String[0]);
            }
            ResourceBundle.clearCache();
        }
    }

    private void log(T work, String destinationName, String stage) {
        String queueMessage = "processing " + work.toString() + " from work queue " + destinationName + " " + stage;
        if (!destinationName.endsWith("EVENTS_QUEUE")) {
            queueMessage = destinationName.endsWith("SIP_LOADING_WORK_QUEUE") ? queueMessage.replaceAll("sipId=", "SIP ") : this.getBuffer(destinationName) + queueMessage;
            log.info(queueMessage);
        } else {
            log.debug((Object)queueMessage, new String[0]);
        }
    }

    private String getBuffer(String destinationName) {
        String buffer = "";
        if (destinationName.endsWith("DEPOSIT_WORK_QUEUE")) {
            buffer = "    ";
        } else if (destinationName.endsWith("SIP_PROCESSING_QUEUE") || destinationName.endsWith("PERMANENT_WORK_QUEUE")) {
            buffer = "  ";
        }
        return buffer;
    }
}

