/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.tools.user;

import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.UserManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;

public class UserUtil {
    public static String fullUserDisplayName(HFrUser user) {
        return UserUtil.fullUserDisplayName(user, null);
    }

    @Deprecated
    public static String fullUserDisplayName(HFrUser user, String recordType) {
        return UserUtil.fullUserDisplayName(user, recordType, "CRS00");
    }

    public static String fullUserDisplayName(HFrUser user, String recordType, String owner) {
        List<HMappingTables> mappingTables;
        CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        String displayName = "";
        String curName = "";
        if (user == null) {
            return displayName;
        }
        if (recordType == null) {
            recordType = user.getRecordType().toString();
        }
        if ((mappingTables = codeTableManager.findMappingsByTableNameAndTarget("DisplayUserName", recordType, owner)) != null && mappingTables.size() > 0) {
            try {
                Method method;
                PropertyDescriptor descriptor;
                HMappingTables row = mappingTables.get(0);
                if (row.getSourceCode1() != null) {
                    descriptor = new PropertyDescriptor(row.getSourceCode1(), user.getClass());
                    method = descriptor.getReadMethod();
                    curName = (String)method.invoke((Object)user, (Object[])null);
                    displayName = displayName + (curName == null ? "" : curName);
                }
                if (row.getSourceCode2() != null) {
                    descriptor = new PropertyDescriptor(row.getSourceCode2(), user.getClass());
                    method = descriptor.getReadMethod();
                    curName = (String)method.invoke((Object)user, (Object[])null);
                    displayName = displayName + (curName == null ? "" : " " + curName);
                }
                if (row.getSourceCode3() != null) {
                    descriptor = new PropertyDescriptor(row.getSourceCode3(), user.getClass());
                    method = descriptor.getReadMethod();
                    curName = (String)method.invoke((Object)user, (Object[])null);
                    displayName = displayName + (curName == null ? "" : " " + curName);
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return displayName;
    }

    public static String fullUserDisplayName(String userName) {
        UserManager manager = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class);
        try {
            HFrUser user = manager.getUserByName(userName);
            return UserUtil.fullUserDisplayName(user);
        }
        catch (Exception e) {
            return null;
        }
    }
}

