/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.repository.convertors;

import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.repository.convertors.AbstractObjectConvertor;
import com.exlibris.core.repository.convertors.ObjectConvertor;
import com.exlibris.core.repository.ifc.SearchServices;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.digitool.repository.api.xmlbeans.ObjectType;
import com.exlibris.digitool.repository.api.xmlbeans.XQueriesDocument;
import com.exlibris.digitool.repository.ifc.RepositoryServices;
import com.exlibris.repository.maintenance.FileInfo;
import com.exlibris.repository.maintenance.IeFilesInfo;
import com.exlibris.repository.maintenance.SetMembers;
import com.exlibris.repository.persistence.HDeSet;
import com.exlibris.repository.persistence.HDeSetMember;
import com.exlibris.repository.persistence.digitalentity.SearchAPIResultRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ObjSetMembersConvertor
extends AbstractObjectConvertor
implements ObjectConvertor {
    @Override
    public Object convertEntityToWS(Object entity) {
        HDeSet set = (HDeSet)entity;
        SetMembers setMembers = new SetMembers();
        setMembers.setSetId(set.getId());
        setMembers.setSetName(set.getName());
        setMembers.setFilesCount(0);
        setMembers.setIesCount(0);
        setMembers.setIesFilesSizeSum(0L);
        ArrayList<IeFilesInfo> ieFilesInfoList = new ArrayList<IeFilesInfo>();
        SearchServices searchServices = (SearchServices)ServiceLocator.getInstance().lookUp(SearchServices.class);
        List<String> pids = this.getSetFilePids(set);
        String[] selectedColumns = new String[]{"IE.internalIdentifier.internalIdentifierType.PID", "FILE.internalIdentifier.internalIdentifierType.PID", "FILE.generalFileCharacteristics.fileSizeBytes", "FILE.internalIdentifier.internalIdentifierType.UUID"};
        List<SearchAPIResultRow> results = searchServices.createResults(Enum.ObjectType.FILE.name(), pids, selectedColumns);
        String curIePid = null;
        IeFilesInfo ieFilesInfo = null;
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        String iePid = null;
        String filePid = null;
        String fileUid = null;
        Long fileSize = null;
        for (SearchAPIResultRow cur : results) {
            iePid = cur.getResults().get("IE.internalIdentifier.internalIdentifierType.PID").getValue();
            filePid = cur.getResults().get("FILE.internalIdentifier.internalIdentifierType.PID").getValue();
            fileUid = cur.getResults().get("FILE.internalIdentifier.internalIdentifierType.UUID").getValue();
            fileSize = Long.valueOf(cur.getResults().get("FILE.generalFileCharacteristics.fileSizeBytes").getValue());
            if (!iePid.equals(curIePid)) {
                ieFilesInfo = new IeFilesInfo();
                fileInfoList = new ArrayList();
                ieFilesInfo.setIePID(iePid);
                ieFilesInfo.setFileInfoList(fileInfoList);
                ieFilesInfo.setFilesSizeSum(0L);
                ieFilesInfoList.add(ieFilesInfo);
                setMembers.setIesCount(setMembers.getIesCount() + 1);
                curIePid = iePid;
            }
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFilePid(filePid);
            fileInfo.setFileSize(fileSize);
            fileInfo.setFileUid(fileUid);
            fileInfo.setIePid(curIePid);
            setMembers.setFilesCount(setMembers.getFilesCount() + 1);
            ieFilesInfo.setFilesSizeSum(ieFilesInfo.getFilesSizeSum() + fileInfo.getFileSize());
            setMembers.setIesFilesSizeSum(setMembers.getIesFilesSizeSum() + fileInfo.getFileSize());
            fileInfoList.add(fileInfo);
        }
        setMembers.setIeFilesInfo(ieFilesInfoList);
        return setMembers;
    }

    private List<String> getSetFilePids(HDeSet set) {
        ArrayList<String> pids = new ArrayList<String>();
        ArrayList<String> scope = new ArrayList<String>();
        scope.add(set.getOwner());
        switch (set.getSetType()) {
            case ITEMIZED: {
                List<HDeSetMember> members = set.getSetMemberList();
                if (members == null) break;
                RepositoryServices repositoryServices = (RepositoryServices)ServiceLocator.getInstance().lookUp(RepositoryServices.class);
                for (HDeSetMember member : members) {
                    for (String repId : repositoryServices.getRepsPids(member.getKey())) {
                        pids.addAll(repositoryServices.getFilesPids(repId, false));
                    }
                }
                break;
            }
            case QUERY: {
                SearchServices searchServices = (SearchServices)ServiceLocator.getInstance().lookUp(SearchServices.class);
                XQueriesDocument xqd = null;
                Map<Long, List<String>> pidsResult = null;
                try {
                    xqd = XQueriesDocument.Factory.parse(set.getValue());
                    xqd.getXQueries().getXQueryArray(0).getXSelect().setObjectType(ObjectType.FILE);
                    pidsResult = searchServices.getPidsListAndTotalCount(xqd, 0, null, scope);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (pidsResult == null) {
                    return null;
                }
                for (Long count : pidsResult.keySet()) {
                    pids.addAll((Collection<String>)pidsResult.get(count));
                }
                break;
            }
        }
        return pids;
    }
}

