/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.formatting;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.pds.PdsConnector;
import com.exlibris.core.infra.svc.api.pds.PdsUserInfo;
import com.exlibris.digitool.common.jobs.xmlbeans.IngestAccessRights;
import com.exlibris.digitool.common.jobs.xmlbeans.IngestSettingsDocument;
import com.exlibris.digitool.common.jobs.xmlbeans.Param;
import com.exlibris.digitool.config.ConfigurationManager;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.digitool.repository.api.xmlbeans.AccessRightMdDocument;
import com.exlibris.digitool.repository.api.xmlbeans.ArExpression;
import com.exlibris.digitool.repository.api.xmlbeans.ArExpressions;
import com.exlibris.digitool.repository.api.xmlbeans.ArKey;
import com.exlibris.digitool.repository.api.xmlbeans.ArOperation;
import com.exlibris.digitool.repository.unitConf.xmlbeans.AccessRight;
import com.exlibris.digitool.repository.unitConf.xmlbeans.Restriction;
import org.apache.xmlbeans.XmlException;

public class AccessRightsBuilder {
    public static final String PLACE_HOLDER_PREFIX = "@";
    public static final String PLACE_HOLDER_SUFFIX = "@";
    public static final String bor_permission = "bor_permission";
    public static final String bor_group = "bor_group";
    public static final String course_enrollment = "course_enrollment";
    public static final String user_id = "user_id";
    public static final String user_name = "user_name";
    public static final String user_ip = "user_ip";
    public static final String expiry_date = "expiry_date";
    private static ExLogger logger = ExLogger.getExLogger(AccessRightsBuilder.class);

    public AccessRightMdDocument createAccessRightsFromTemplate(String temp, IngestSettingsDocument ar) throws XmlException {
        AccessRightMdDocument accessRightMdDocument;
        Param[] prms = ar.getIngestSettings().getIngestAccessRights().getParamArray();
        if (temp != null && temp.length() > 0) {
            for (int i = 0; i < prms.length; ++i) {
                String name = prms[i].getName();
                String val = prms[i].getValue();
                temp = temp.replaceAll("@" + name + "@", val);
            }
            accessRightMdDocument = AccessRightMdDocument.Factory.parse(temp);
        } else {
            accessRightMdDocument = AccessRightMdDocument.Factory.newInstance();
            ArExpressions exps = accessRightMdDocument.addNewAccessRightMd().addNewArConditions().addNewArCondition().addNewArExpressions();
            for (int i = 0; i < prms.length; ++i) {
                ArKey.Enum key = this.getKeyEnum(prms[i].getName());
                if (key == null) continue;
                String val = prms[i].getValue();
                ArExpression exp = exps.addNewArExpression();
                exp.setArOperation(ArOperation.EQ);
                exp.setKey(key);
                exp.setVal1(val);
            }
        }
        return accessRightMdDocument;
    }

    private ArKey.Enum getKeyEnum(String key) {
        if (key.equals(bor_group)) {
            return ArKey.GROUP;
        }
        if (key.equals(user_id)) {
            return ArKey.USER_ID;
        }
        return null;
    }

    public IngestSettingsDocument addAccessRightsToIngestSttings(IngestSettingsDocument ingestSettingsDocument, String arId, String pdsId) throws DigitoolException {
        try {
            int i;
            IngestAccessRights ingestAccessRights;
            IngestSettingsDocument.IngestSettings inst = ingestSettingsDocument.getIngestSettings();
            if (inst == null) {
                inst = ingestSettingsDocument.addNewIngestSettings();
            }
            if ((ingestAccessRights = inst.getIngestAccessRights()) == null) {
                ingestAccessRights = inst.addNewIngestAccessRights();
            }
            ingestAccessRights.setAccessRightId(arId);
            ingestAccessRights.setPdsUserId(pdsId);
            PdsConnector pdsConnector = PdsConnector.getInstance();
            PdsUserInfo inf = pdsConnector.getPdsUserInfoByUserId(pdsId);
            AccessRight ar = ConfigurationManager.getInstance().getAccessRight(arId);
            Restriction[] rests = ar.getRestrictions() != null ? ar.getRestrictions().getRestrictionArray() : new Restriction[]{};
            Param[] prms = ingestAccessRights.getParamArray();
            for (i = 0; i < prms.length; ++i) {
                ingestAccessRights.removeParam(i);
            }
            for (i = 0; i < rests.length; ++i) {
                Param prm = ingestAccessRights.addNewParam();
                prm.setName(rests[i].getKey());
                String val = this.getValFromPdsUserInfo(inf, rests[i].getKey());
                prm.setValue(val);
            }
            return ingestSettingsDocument;
        }
        catch (Exception e) {
            logger.error(DescriptorConstants.GN_UnexpectedError, (Object)e.getMessage(), e);
            throw new DigitoolException(DescriptorConstants.GN_UnexpectedError, (Throwable)e);
        }
    }

    private String getValFromPdsUserInfo(PdsUserInfo inf, String key) {
        if (key.equals(bor_permission)) {
            return inf.getBorPermission();
        }
        if (key.equals(bor_group)) {
            return inf.getBorGroup();
        }
        if (key.equals(course_enrollment)) {
            return inf.getBorGroup();
        }
        if (key.equals(user_id)) {
            return inf.getUserId();
        }
        if (key.equals(user_name)) {
            return inf.getUserName();
        }
        if (key.equals(user_ip)) {
            return inf.getUserIp();
        }
        if (key.equals(expiry_date)) {
            return inf.getExpiryDate();
        }
        return null;
    }
}

