/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.xml.XMLNormalizer;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.common.streams.ExternalProcessUtil;
import com.exlibris.digitool.common.streams.FailedToHandlerStreamException;
import com.exlibris.digitool.common.streams.StreamHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;

public class PDFTextExtractorStreamHandler
extends StreamHandler {
    private String fullTextShell = FSUtil.getProductDir() + "pdftotext";
    private static final ExLogger logger = ExLogger.getExLogger(PDFTextExtractorStreamHandler.class);
    private static final String START_TAGS = "<html><body><pre>";
    private static final String END_TAGS = "</pre></body></html>";
    private static final String[] formattedFiles = new String[]{"html", "htm"};
    private String encoding = "UTF-8";
    private static final String UTF8 = "UTF-8";

    @Override
    public void handleStream() throws FailedToHandlerStreamException {
        String fileToRead = null;
        String fileToWrite = null;
        String fileToWriteTmp = null;
        if (this.params != null && this.params.length == 2) {
            fileToRead = this.params[0];
            fileToWrite = this.params[1];
            fileToWriteTmp = fileToWrite + ".tmp";
            try {
                this.paramsPattern = this.paramsPattern.replaceAll("-htmlmeta", " ");
                Object[] workerParams = new Object[]{fileToRead, fileToWriteTmp};
                ExternalProcessUtil.runScript(this.fullTextShell, this.paramsPattern, workerParams);
                if (FileUtil.getFileSize(fileToWriteTmp) == 0L) {
                    logger.info(DescriptorConstants.IN_UnableToCreateStream, (Object)this.fullTextShell, (Object)"NONE", (Object)"File size is 0");
                    throw new FailedToHandlerStreamException("Failed to create the stream file size is 0");
                }
            }
            catch (Exception e) {
                logger.info(DescriptorConstants.IN_UnableToCreateStream, (Object)this.fullTextShell, e.getClass(), (Object)e.getMessage());
                throw new FailedToHandlerStreamException("Failed to create the stream using " + this.fullTextShell + " Exception: " + e.getMessage());
            }
            FileInputStream input = null;
            OutputStream os = null;
            StringBuffer document = new StringBuffer();
            try {
                int len = 0;
                input = new FileInputStream(fileToWriteTmp);
                byte[] buf = new byte[input.available()];
                document.append(START_TAGS);
                while ((len = input.read(buf)) != -1) {
                    String str;
                    try {
                        str = new String(buf, 0, len, this.encoding);
                    }
                    catch (UnsupportedCharsetException e) {
                        str = new String(buf);
                    }
                    catch (IndexOutOfBoundsException e) {
                        str = new String(buf);
                    }
                    str = XMLNormalizer.normalize(str);
                    document.append(str.toLowerCase());
                }
                document.append(END_TAGS);
                if (document.length() > 0) {
                    os = new FileOutputStream(fileToWrite);
                    os.write(document.toString().getBytes(UTF8));
                }
                File fileToWriteTmpHandle = new File(fileToWriteTmp);
                fileToWriteTmpHandle.delete();
            }
            catch (FileNotFoundException e) {
                if (input == null) {
                    logger.info(DescriptorConstants.GN_FailedToReadFile, (Object)fileToRead, (Object)e.getMessage());
                    throw new FailedToHandlerStreamException("failed to create index file, '" + fileToRead + "' - not found: " + e.getStackTrace());
                }
                logger.info(DescriptorConstants.GN_FailedToReadFile, (Object)fileToWrite, (Object)e.getMessage());
                throw new FailedToHandlerStreamException("failed to create index file, '" + fileToWrite + "' - not found: " + e.getStackTrace());
            }
            catch (SecurityException e) {
                if (input == null) {
                    logger.info(DescriptorConstants.GN_FailedToReadFile, (Object)fileToRead, (Object)e.getMessage());
                    throw new FailedToHandlerStreamException("failed to create index file, '" + fileToRead + "' - cannot be read: " + e.getStackTrace());
                }
                logger.info(DescriptorConstants.GN_FailedToReadFile, (Object)fileToWrite, (Object)e.getMessage());
                throw new FailedToHandlerStreamException("failed to create index file, '" + fileToWrite + "' - cannot be write: " + e.getStackTrace());
            }
            catch (IOException e) {
                logger.info(DescriptorConstants.IN_UnableToSaveStreamFile, (Object)fileToWrite, (Object)e.getMessage());
                throw new FailedToHandlerStreamException("failed to create index file, '" + fileToWrite + "' - cannot be write: " + e.getStackTrace());
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ex) {
                    logger.info(DescriptorConstants.GN_UnableToCloseStream, (Object)ex.getMessage());
                }
            }
        }
        throw new FailedToHandlerStreamException("one of the following is missing: 'file to read', 'file to write'");
    }

    private boolean shouldBeFormatted(String fileExt) {
        return fileExt == null || fileExt.trim().length() == 0 || !Arrays.asList(formattedFiles).contains(fileExt);
    }
}

