/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.common.jobs.xmlbeans.IngestSettingsDocument;
import com.exlibris.digitool.common.jobs.xmlbeans.Param;
import com.exlibris.digitool.common.jobs.xmlbeans.TaskSettings;
import com.exlibris.digitool.common.jobs.xmlbeans.TasksChain;
import com.exlibris.digitool.common.streams.StreamHandlerUtil;
import com.exlibris.digitool.common.streams.xmlbeans.DefaultParam;
import com.exlibris.digitool.common.streams.xmlbeans.PreingestHandler;
import com.exlibris.digitool.common.streams.xmlbeans.TaskChain;
import com.exlibris.digitool.repository.system.RpException;
import java.io.InputStream;
import java.util.Hashtable;

public class RepositoryStreamHandlerManager {
    private static final String STREAM_HANDLER_FILE = "repository_stream_handler.xml";
    private static RepositoryStreamHandlerManager rshMngr;
    private static final ExLogger log;
    private final Hashtable taskChainsHash = new Hashtable();
    private final Hashtable preingestHandlerHash = new Hashtable();
    private final Hashtable preingestHandlerHashByDisplayName = new Hashtable();
    private final Hashtable streamHandlerUtilHash = new Hashtable();
    TaskChain[] taskChainsArr;

    public static RepositoryStreamHandlerManager getInstance() {
        if (rshMngr == null) {
            rshMngr = new RepositoryStreamHandlerManager();
            rshMngr.load();
        }
        return rshMngr;
    }

    private void load() {
        try {
            log.info("Looking for repository stream handler file: repository_stream_handler.xml ...");
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(STREAM_HANDLER_FILE);
            if (in == null) {
                log.error("stream handler file not found - repository_stream_handler.xml", new String[0]);
            }
            log.info("repository stream handler file found.");
            this.hashTaskChains();
            this.hashStreamHandlerUtil();
            this.hashPreingestHandlers();
            log.info("Setting Loaded");
        }
        catch (Throwable e) {
            log.error("Failed to load configuration from repository_stream_handler.xml: " + e.getMessage() + e.getLocalizedMessage() + e.getCause(), new String[0]);
        }
    }

    private void hashTaskChains() {
    }

    private void hashPreingestHandlers() {
    }

    private void hashStreamHandlerUtil() {
    }

    public StreamHandlerUtil[] getStreamHandlerUtil() {
        return this.streamHandlerUtilHash.values().toArray(new StreamHandlerUtil[0]);
    }

    public StreamHandlerUtil getStreamHandlerUtil(String name) {
        try {
            StreamHandlerUtil ar = (StreamHandlerUtil)this.streamHandlerUtilHash.get(name);
            if (ar != null) {
                // empty if block
            }
            if (ar == null) {
                throw new RpException("StreamHandlerUtil not defined in repository_stream_handler.xml - name=" + name);
            }
            return ar;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public PreingestHandler[] getPreingestHandlers() {
        return this.preingestHandlerHash.values().toArray(new PreingestHandler[0]);
    }

    public PreingestHandler getPreingestHandler(String name) {
        try {
            PreingestHandler ar = (PreingestHandler)this.preingestHandlerHash.get(name);
            if (ar != null) {
                ar = (PreingestHandler)ar.copy();
            }
            if (ar == null) {
                throw new RpException("PreingestHandler not defined in repository_stream_handler.xml - name=" + name);
            }
            return ar;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public PreingestHandler getPreingestHandlerByDisplayName(String name) {
        try {
            PreingestHandler ar = (PreingestHandler)this.preingestHandlerHashByDisplayName.get(name);
            if (ar != null) {
                ar = (PreingestHandler)ar.copy();
            }
            if (ar == null) {
                throw new RpException("PreingestHandler not defined in repository_stream_handler.xml - name=" + name);
            }
            return ar;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public TaskChain[] getTaskChains() {
        return this.taskChainsArr;
    }

    public TaskChain getTaskChain(String name) {
        try {
            TaskChain ar = (TaskChain)this.taskChainsHash.get(name);
            if (ar != null) {
                ar = (TaskChain)ar.copy();
            }
            if (ar == null) {
                throw new RpException("TaskChain not defined in repository_stream_handler.xml - name=" + name);
            }
            return ar;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public IngestSettingsDocument addChainToIngestSettings(IngestSettingsDocument ingSettings, String taskName) {
        IngestSettingsDocument.IngestSettings ingestSettings;
        TaskChain taskChain = this.getTaskChain(taskName);
        if (taskChain == null) {
            return ingSettings;
        }
        IngestSettingsDocument ingestSettingsDoc = ingSettings;
        if (ingestSettingsDoc == null) {
            ingestSettingsDoc = IngestSettingsDocument.Factory.newInstance();
            ingestSettingsDoc.addNewIngestSettings();
        }
        if ((ingestSettings = ingestSettingsDoc.getIngestSettings()) == null) {
            ingestSettings = ingestSettingsDoc.addNewIngestSettings();
        }
        TasksChain ingsetTaskChain = ingestSettings.addNewTasksChain();
        ingsetTaskChain.setName(taskChain.getChainName());
        TaskSettings ingsetTaskSetting = null;
        String[] preIngestHandlers = taskChain.getPreingestHandlerNameArray();
        for (int i = 0; i < preIngestHandlers.length; ++i) {
            ingsetTaskSetting = ingsetTaskChain.addNewTaskSettings();
            PreingestHandler handler = this.getPreingestHandler(preIngestHandlers[i]);
            ingsetTaskSetting.setName(handler.getName());
            ingsetTaskSetting.setTaskName(handler.getTaskName());
            DefaultParam[] defaultParam = handler.getDefaultParamArray();
            for (int j = 0; j < defaultParam.length; ++j) {
                Param param = ingsetTaskSetting.addNewParam();
                param.setName(defaultParam[j].getParamName());
                param.setValue(defaultParam[j].getValue());
            }
        }
        return ingestSettingsDoc;
    }

    static {
        log = ExLogger.getExLogger(RepositoryStreamHandlerManager.class);
    }
}

