/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.model.rules.HFrRuleParam;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.RulesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.digitool.common.streams.EventDetails;
import com.exlibris.digitool.common.streams.StreamHandler;
import com.exlibris.digitool.common.streams.StreamHandlerUtil;
import com.exlibris.digitool.rules.enums.GENERIC_REPRESENTATION_CREATION_RULES_IN;
import com.exlibris.digitool.rules.enums.THUMBNAIL_RULES_IN;
import com.exlibris.digitool.rules.enums.THUMBNAIL_RULES_OUT;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class StreamHandlersMngr {
    private static StreamHandlersMngr shmngr;
    private static final ExLogger logger;
    private static final String ALL_FILES = "*";
    private final Hashtable preingestHandlers = new Hashtable();
    private final Hashtable streamHandlers = new Hashtable();

    public static synchronized StreamHandlersMngr getInstance() {
        if (shmngr == null) {
            shmngr = new StreamHandlersMngr();
            shmngr.load();
        }
        return shmngr;
    }

    private void load() {
    }

    public StreamHandlerUtil getStreamHandlerUtil(String name) {
        return (StreamHandlerUtil)this.streamHandlers.get(name);
    }

    public List<HFrRuleParam> getOutputRuleParams(String taskName, String droidId, String fileExt, String ruleType) {
        RulesManager rulesManager = this.getRulesManager();
        HashMap<String, String> params = new HashMap<String, String>();
        if (taskName != null) {
            params.put(GENERIC_REPRESENTATION_CREATION_RULES_IN.TaskName.toString(), taskName);
        }
        params.put(THUMBNAIL_RULES_IN.FileExtension.toString(), fileExt);
        params.put(GENERIC_REPRESENTATION_CREATION_RULES_IN.DroidId.toString(), droidId);
        List<HFrRuleParam> outPutRulesParam = rulesManager.getMatchingRuleOutputForAllInstitution(ruleType, params);
        if (outPutRulesParam == null || outPutRulesParam.size() == 0) {
            logger.warn((Object)("StreamHandlersMngr unable to find output rules for Rule Type: " + ruleType + " and input rules : TaskName = " + taskName + ", FileExtension = " + fileExt + ", DroidId = " + droidId), new String[0]);
            return null;
        }
        return outPutRulesParam;
    }

    public StreamHandlerUtil getHandler(String taskName, String droidId, String fileExt, String ruleType) {
        HFrRuleParam param2;
        StreamHandlerUtil util = null;
        List<HFrRuleParam> outPutRulesParam = this.getOutputRuleParams(taskName, droidId, fileExt, ruleType);
        HashMap<String, HFrRuleParam> outputParams = new HashMap<String, HFrRuleParam>();
        if (outPutRulesParam == null || outPutRulesParam.size() == 0) {
            logger.warn((Object)("StreamHandlersMngr unable to find output rules for Rule Type: " + ruleType + " and input rules : TaskName = " + taskName + ", FileExtension = " + fileExt + ", DroidId = " + droidId), new String[0]);
            return null;
        }
        for (HFrRuleParam param2 : outPutRulesParam) {
            outputParams.put(param2.getName(), param2);
        }
        PluginType pluginType = outputParams.get(THUMBNAIL_RULES_OUT.PluginType.toString()) == null || ((HFrRuleParam)outputParams.get(THUMBNAIL_RULES_OUT.PluginType.toString())).getValue() == null ? PluginType.StreamHandlerUtil : PluginType.valueOf(((HFrRuleParam)outputParams.get(THUMBNAIL_RULES_OUT.PluginType.toString())).getValue());
        param2 = null;
        switch (pluginType) {
            case StreamHandlerUtil: {
                param2 = (HFrRuleParam)outputParams.get(PluginType.StreamHandlerUtil.toString());
                CodeTablesManager codeTablesMgr = this.getCodeTablesManager();
                List<HMappingTables> mappingList = codeTablesMgr.findMappingsByTableNameAndTarget("StreamHandlerUtil", param2.getValue());
                if (mappingList == null || mappingList.size() == 0) {
                    logger.error("StreamHandlersMngr unable to find Mapping table for stream handler: " + param2.getValue() + " And params : taskName: " + taskName + " fileExtention:" + fileExt + " DroidId:" + droidId, new String[0]);
                    throw new IllegalArgumentException("Mapping table not found for Stream handler: " + param2.getValue());
                }
                if (mappingList.size() > 1) {
                    logger.error("StreamHandlersMngr found more than one Stream handler for: " + param2.getValue(), new String[0]);
                }
                util = new StreamHandlerUtil();
                HMappingTables mapping = mappingList.get(0);
                util.setName(mapping.getTargetCode());
                util.setWorkerType(Enum.valueOf(StreamHandlerUtil.WorkerType.class, mapping.getSourceCode1().toUpperCase()));
                util.setWorker(mapping.getSourceCode2());
                util.setFileExt(mapping.getSourceCode3());
                util.setParamsPattern(mapping.getSourceCode4());
                EventDetails event = new EventDetails();
                event.setEventDetails("event Id  = " + mapping.getSourceCode5());
                util.setEventDetails(event);
                break;
            }
        }
        return util;
    }

    private RulesManager getRulesManager() {
        return (RulesManager)ServiceLocator.getInstance().lookUp(RulesManager.class);
    }

    public StreamHandler getStreamHandler(StreamHandlerUtil streamHandlerUtil) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String worker = this.getScriptWorker(streamHandlerUtil);
        if (this.streamHandlers.contains(worker)) {
            return (StreamHandler)this.streamHandlers.get(worker);
        }
        StreamHandler streamHandler = (StreamHandler)Class.forName(worker).newInstance();
        streamHandler.setParamsPattern(streamHandlerUtil.getParamsPattern());
        this.streamHandlers.put(worker, streamHandler);
        return streamHandler;
    }

    public String getScriptWorker(StreamHandlerUtil streamHandlerUtil) {
        return streamHandlerUtil.getWorkerType().equals((Object)StreamHandlerUtil.WorkerType.EXTERNAL_PROGRAM) ? FSUtil.getSystemDir() + "bin" + File.separator + streamHandlerUtil.getWorker() + FSUtil.getBatchExtention() : streamHandlerUtil.getWorker();
    }

    private CodeTablesManager getCodeTablesManager() {
        return (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
    }

    static {
        logger = ExLogger.getExLogger(StreamHandlersMngr.class);
    }

    public static enum PluginType {
        TransformationProfile,
        StreamHandlerUtil;

    }
}

