/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.config;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.filetable.HFileTable;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.digitool.repository.conf.xmlbeans.RepositoryJob;
import com.exlibris.digitool.repository.conf.xmlbeans.RpJobsConfigurationDocument;
import com.exlibris.digitool.shared.dataObjects.ComparableKeyValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationJobManager {
    private static ExLogger log = ExLogger.getExLogger(ConfigurationJobManager.class);
    private RpJobsConfigurationDocument rpjcd;
    private List classNameKeyValuePair;
    private Map classNameMap;
    private static final String RP_JOBS_CONF_FILE = "com.exlibris.dps.repository.jobsconfiguration";
    private static ConfigurationJobManager cjm = new ConfigurationJobManager();

    public static ConfigurationJobManager getInstance() {
        if (cjm == null) {
            cjm = new ConfigurationJobManager();
        }
        return cjm;
    }

    private ConfigurationJobManager() {
        this.load();
    }

    private void load() {
        try {
            log.info("Looking for configuration file: com.exlibris.dps.repository.jobsconfiguration ...");
            FileTableManager manager = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
            HFileTable confFile = manager.getFileByKey(RP_JOBS_CONF_FILE);
            log.info("Configuration file found.");
            this.rpjcd = RpJobsConfigurationDocument.Factory.parse(confFile.getFile());
            this.initMap();
            this.initList();
            log.info("Setting Loaded");
        }
        catch (Throwable e) {
            log.error("Failed to load configuration from com.exlibris.dps.repository.jobsconfiguration: " + e.getMessage() + e.getLocalizedMessage() + e.getCause(), new String[0]);
        }
    }

    private void initMap() {
        this.classNameMap = new HashMap();
        try {
            RepositoryJob[] repositoryJobArray = this.rpjcd.getRpJobsConfiguration().getRepositoryJobs().getRepositoryJobArray();
            for (int i = 0; i < repositoryJobArray.length; ++i) {
                this.classNameMap.put(repositoryJobArray[i].getJobClass(), repositoryJobArray[i].getName());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void initList() {
        this.classNameKeyValuePair = new ArrayList();
        if (this.classNameMap == null) {
            return;
        }
        for (Map.Entry entry : this.classNameMap.entrySet()) {
            ComparableKeyValuePair currValue = new ComparableKeyValuePair(entry.getKey(), (Comparable)entry.getValue());
            this.classNameKeyValuePair.add(currValue);
        }
    }

    public RpJobsConfigurationDocument getRpJobsConfigurationDocument() {
        return this.rpjcd;
    }

    public List getClassNameKeyValuePairList() {
        return this.classNameKeyValuePair;
    }

    public Map getClassNameMap() {
        return this.classNameMap;
    }

    public static void reset() {
        cjm = null;
    }
}

