/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.dps.model.collections;

import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.svc.api.utils.TreeNode;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.repository.persistence.HOwneredEntity;
import com.exlibris.repository.persistence.digitalentity.HDeMetadata;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"externalSystem", "externalId"})})
public class HDeCollection
extends HOwneredEntity
implements TreeNode {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private Enum.CollectionStatus status;
    private Long parentId;
    private List<HDeMetadata> metadatas;
    private String externalSystem;
    private String externalId;
    private boolean publish;
    private boolean navigate;
    private boolean hasChildren;
    private String indexXml;
    private int collectionOrder;

    @Override
    @Searchable
    public String getName() {
        return this.name;
    }

    @Override
    @Searchable
    public String getDescription() {
        return this.description;
    }

    @Searchable
    @Enumerated(value=EnumType.STRING)
    public Enum.CollectionStatus getStatus() {
        return this.status;
    }

    @Override
    public Long getParentId() {
        return this.parentId;
    }

    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="HDECOLLECTIONMID", uniqueConstraints={@UniqueConstraint(columnNames={"METADATAS_ID", "HDECOLLECTION_ID"})})
    public List<HDeMetadata> getMetadatas() {
        return this.metadatas;
    }

    public String getExternalSystem() {
        return this.externalSystem;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public int getCollectionOrder() {
        return this.collectionOrder;
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(Enum.CollectionStatus status) {
        this.status = status;
    }

    public void setMetadatas(List<HDeMetadata> metadataList) {
        this.metadatas = metadataList;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public void setExternalSystem(String externalSystem) {
        this.externalSystem = externalSystem;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public void setCollectionOrder(int collectionOrder) {
        this.collectionOrder = collectionOrder;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    @Transient
    public void addMetadata(HDeMetadata metadata) {
        if (this.metadatas == null) {
            this.metadatas = new ArrayList<HDeMetadata>();
        }
        this.metadatas.add(metadata);
    }

    @Transient
    public List<HDeMetadata> getSourceMD() {
        ArrayList<HDeMetadata> ret = new ArrayList<HDeMetadata>();
        if (this.metadatas == null) {
            return ret;
        }
        for (HDeMetadata md : this.metadatas) {
            if ((md.getMdId() < 61 || md.getMdId() > 70) && md.getMdId() != 73) continue;
            ret.add(md);
        }
        return ret;
    }

    public void setSourceMD(List<HDeMetadata> sourceMd) {
        for (HDeMetadata smd : sourceMd) {
            boolean addMetadata = true;
            for (HDeMetadata md : this.metadatas) {
                if (md.getMdId() != smd.getMdId()) continue;
                md = smd;
                addMetadata = false;
            }
            if (!addMetadata) continue;
            this.metadatas.add(smd);
        }
    }

    @Transient
    public HDeMetadata getDcMD() {
        if (this.metadatas == null) {
            return null;
        }
        for (HDeMetadata md : this.metadatas) {
            if (md.getMdId() != 2) continue;
            return md;
        }
        return null;
    }

    @Transient
    public HDeMetadata getCollectionMets() {
        if (this.metadatas == null) {
            return null;
        }
        for (HDeMetadata md : this.metadatas) {
            if (md.getMdId() != 71) continue;
            return md;
        }
        return null;
    }

    public String toString() {
        return "HDeCollection [name=" + this.name + ", parentId=" + this.parentId + ", owner=" + this.getOwner() + ", description=" + this.description + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.metadatas == null ? 0 : this.metadatas.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parentId == null ? 0 : this.parentId.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDeCollection other = (HDeCollection)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.metadatas == null ? other.metadatas != null : !this.metadatas.equals(other.metadatas)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parentId == null ? other.parentId != null : !this.parentId.equals(other.parentId)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals((Object)other.status));
    }

    public boolean isNavigate() {
        return this.navigate;
    }

    public void setNavigate(boolean navigate) {
        this.navigate = navigate;
    }

    @Override
    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }
}

